/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.param.collection.FieldType;

public class DocField {
    private final String name;
    private final Object value;

    public DocField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public Long getLongValue() {
        return Long.valueOf(this.value.toString());
    }

    public FieldType getFieldType() {
        if (this.value == null) {
            throw new VectorDBException("DocField value is null, filed name is " + this.name);
        }
        String valueClassName = this.value.getClass().getName();
        if (valueClassName.equals("java.lang.Integer") || valueClassName.equals("java.lang.Long")) {
            return FieldType.Uint64;
        }
        return FieldType.String;
    }
}

