/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.model.DocField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Document {
    private String id;
    private List<Double> vector;
    private Double score;
    private String doc;
    private List<DocField> docFields;

    public String getId() {
        return this.id;
    }

    public Double getScore() {
        return this.score;
    }

    public String getDoc() {
        return this.doc;
    }

    public List<DocField> getDocFields() {
        return this.docFields;
    }

    public List<Double> getVector() {
        return Collections.unmodifiableList(this.vector);
    }

    public String toString() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            node.put("id", this.id);
        }
        if (this.vector != null && !this.vector.isEmpty()) {
            ArrayNode vectorNode = JsonNodeFactory.instance.arrayNode();
            this.vector.forEach(arg_0 -> ((ArrayNode)vectorNode).add(arg_0));
            node.set("vector", (JsonNode)vectorNode);
        }
        if (this.score != null) {
            node.put("score", this.score);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.doc)) {
            node.put("doc", this.doc);
        }
        if (this.docFields != null && !this.docFields.isEmpty()) {
            block3: for (DocField field : this.docFields) {
                switch (field.getFieldType()) {
                    case Uint64: {
                        node.put(field.getName(), field.getLongValue());
                        continue block3;
                    }
                }
                node.put(field.getName(), field.getStringValue());
            }
        }
        return node.toString();
    }

    private Document(Builder builder) {
        this.id = builder.id;
        this.vector = builder.vector;
        this.doc = builder.doc;
        this.score = builder.score;
        this.docFields = builder.docFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private List<Double> vector;
        private Double score;
        private String doc;
        private List<DocField> docFields = new ArrayList<DocField>();

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withVector(List<Double> vector) {
            this.vector = vector;
            return this;
        }

        public Builder withDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder withScore(Double score) {
            this.score = score;
            return this;
        }

        @Deprecated
        public Builder addFilterField(DocField field) {
            this.docFields.add(field);
            return this;
        }

        public Builder addDocField(DocField docField) {
            this.docFields.add(docField);
            return this;
        }

        public Builder addDocFields(List<DocField> docFields) {
            this.docFields.addAll(docFields);
            return this;
        }

        public Document build() {
            return new Document(this);
        }
    }
}

