/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.tencent.tcvectordb.model.param.dml.Filter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuery {
    protected String filter;
    protected List<String> documentIds;

    public BaseQuery(Builder<?> builder) {
        if (builder.filter != null) {
            this.filter = builder.filter.getCond();
        }
        this.documentIds = builder.documentIds;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Filter filter;
        protected List<String> documentIds = new ArrayList<String>();

        protected Builder() {
        }

        protected abstract T self();

        public T withFilter(Filter filter) {
            this.filter = filter;
            return this.self();
        }

        public T withDocumentIds(List<String> documentIds) {
            this.documentIds = documentIds;
            return this.self();
        }

        public T addDocumentId(String documentId) {
            this.documentIds.add(documentId);
            return this.self();
        }

        public T addAllDocumentId(List<String> documentIds) {
            this.documentIds.addAll(documentIds);
            return this.self();
        }
    }
}

