/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Filter {
    private StringBuffer condBuffer;

    public Filter(String cond) {
        this.condBuffer = new StringBuffer(cond);
    }

    public Filter and(String cond) {
        this.condBuffer.append(" and ").append(cond);
        return this;
    }

    public Filter or(String cond) {
        this.condBuffer.append(" or ").append(cond);
        return this;
    }

    public Filter andNot(String cond) {
        this.condBuffer.append(" and not ").append(cond);
        return this;
    }

    public Filter orNot(String cond) {
        this.condBuffer.append(" or not ").append(cond);
        return this;
    }

    public static <T> String in(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s in (%s)", key, String.join((CharSequence)",", strValues));
    }

    public String getCond() {
        return this.condBuffer.toString();
    }
}

