/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.Document;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InsertParam {
    private boolean buildIndex;
    private List<Document> documents;

    private InsertParam(Builder builder) {
        this.documents = builder.documents;
        this.buildIndex = builder.buildIndex;
    }

    public boolean isBuildIndex() {
        return this.buildIndex;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean buildIndex = true;
        private List<Document> documents = new ArrayList<Document>();

        public Builder withBuildIndex(boolean buildIndex) {
            this.buildIndex = buildIndex;
            return this;
        }

        public Builder withDocuments(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        public Builder addDocument(Document document) {
            this.documents.add(document);
            return this;
        }

        public Builder addAllDocument(List<Document> documentList) {
            this.documents.addAll(documentList);
            return this;
        }

        public InsertParam build() {
            if (this.documents.isEmpty()) {
                throw new ParamException("InsertParam error: documents is empty");
            }
            return new InsertParam(this);
        }
    }
}

