/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.param.dml.SearchParam;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchByEmbeddingItemsParam
extends SearchParam {
    private List<String> embeddingItems;

    private SearchByEmbeddingItemsParam(Builder builder) {
        super(builder);
        this.embeddingItems = builder.embeddingItems;
    }

    public List<String> getEmbeddingItems() {
        return this.embeddingItems;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends SearchParam.Builder<Builder> {
        private List<String> embeddingItems = new ArrayList<String>();

        private Builder() {
        }

        public Builder withEmbeddingItems(List<String> embeddingItems) {
            this.embeddingItems = embeddingItems;
            return this;
        }

        public Builder addEmbeddingItem(String embeddingItem) {
            this.embeddingItems.add(embeddingItem);
            return this;
        }

        public SearchByEmbeddingItemsParam build() {
            if (this.embeddingItems == null || this.embeddingItems.isEmpty()) {
                throw new ParamException("SearchByEmbeddingItemsBuilder error: embeddingItems is empty");
            }
            return new SearchByEmbeddingItemsParam(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

