/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStub
implements Stub {
    private final ConnectParam connectParam;
    private final OkHttpClient client;
    private final Headers headers;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger((String)HttpStub.class.getName());

    public HttpStub(ConnectParam connectParam) {
        this.connectParam = connectParam;
        String authorization = String.format("Bearer account=%s&api_key=%s", connectParam.getUsername(), connectParam.getKey());
        this.headers = new Headers.Builder().add("Authorization", authorization).build();
        logger.debug("header: {}", (Object)authorization);
        this.client = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).readTimeout((long)connectParam.getTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(10, 5L, TimeUnit.MINUTES)).build();
    }

    @Override
    public void createDatabase(Database database) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/create");
        this.post(url, database.toString());
    }

    @Override
    public void dropDatabase(Database database) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/drop");
        this.post(url, database.toString());
    }

    @Override
    public List<String> listDatabases() {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/list");
        JsonNode jsonNode = this.get(url);
        JsonNode dbsJson = jsonNode.get("databases");
        if (dbsJson == null) {
            return new ArrayList<String>();
        }
        try {
            return (List)this.mapper.readValue(dbsJson.toString(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response error: can't parse databases=%s", dbsJson));
        }
    }

    @Override
    public void createCollection(CreateCollectionParam param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/create");
        this.post(url, param.toString());
    }

    @Override
    public List<Collection> listCollections(String databaseName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/list");
        JsonNode jsonNode = this.post(url, String.format("{\"database\":\"%s\"}", databaseName));
        JsonNode closJson = jsonNode.get("collections");
        if (closJson == null) {
            return new ArrayList<Collection>();
        }
        return JsonUtils.collectionDeserializer(closJson.toString(), new TypeReference<List<Collection>>(){});
    }

    @Override
    public Collection describeCollection(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/describe");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        JsonNode dbsJson = jsonNode.get("collection");
        if (dbsJson == null) {
            return null;
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<Collection>(){});
    }

    @Override
    public AffectRes truncateCollection(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/truncate");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public void dropCollection(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/drop");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        this.post(url, body);
    }

    @Override
    public AffectRes setAlias(String databaseName, String collectionName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/alias/set");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\",\"alias\":\"%s\"}", databaseName, collectionName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes deleteAlias(String databaseName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/alias/delete");
        String body = String.format("{\"database\":\"%s\",\"alias\":\"%s\"}", databaseName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes upsertDocument(InsertParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/upsert");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<Document> queryDocument(QueryParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/query");
        JsonNode jsonNode = this.post(url, param.toString());
        JsonNode docsNode = jsonNode.get("documents");
        ArrayList<Document> dosc = new ArrayList<Document>();
        if (docsNode == null) {
            return dosc;
        }
        try {
            Iterator iterator = docsNode.elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                Document doc = this.node2Doc(node);
                dosc.add(doc);
            }
            return dosc;
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from query error: can't parse documents=%s", docsNode));
        }
    }

    @Override
    public SearchRes searchDocument(SearchParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/search");
        JsonNode jsonNode = this.post(url, param.toString());
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new SearchRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList<List<Document>> multiDosc = new ArrayList<List<Document>>();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                Iterator iter = docNode.elements();
                ArrayList<Document> docs = new ArrayList<Document>();
                while (iter.hasNext()) {
                    JsonNode node = (JsonNode)iter.next();
                    Document doc = this.node2Doc(node);
                    docs.add(doc);
                }
                multiDosc.add(docs);
            }
            return new SearchRes(code, msg, warning, multiDosc);
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public AffectRes deleteDocument(DeleteParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/delete");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes updateDocument(UpdateParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/update");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes rebuildIndex(RebuildIndexParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/index/rebuild");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode get(String url) {
        Request request = new Request.Builder().url(url).headers(this.headers).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            throw new VectorDBException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode post(String url, String json) {
        logger.debug("Query {}, body={}", (Object)url, (Object)json);
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).headers(this.headers).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            throw new VectorDBException(String.format("VectorDBServer IOException: %s", ex.getMessage()));
        }
    }

    private JsonNode parseResponse(Response response) throws IOException {
        ResponseBody resBody = response.body();
        if (resBody == null) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody null, http code=%s, message=%s", response.code(), response.message()));
        }
        String resStr = resBody.string();
        logger.debug("Query {}, code={}, msg={}, result={}", new Object[]{response.request().url(), response.code(), response.message(), resStr});
        if (StringUtils.isEmpty((CharSequence)resStr)) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody empty, http code=%s, message=%s", response.code(), response.message()));
        }
        if (!response.isSuccessful()) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, http code=%s, message=%s, result=%s", response.code(), response.message(), resStr));
        }
        JsonNode jsonNode = this.mapper.readTree(resStr);
        int code = jsonNode.get("code").asInt();
        if (code != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", code, jsonNode.get("msg").asText()));
        }
        return jsonNode;
    }

    private Document node2Doc(JsonNode node) throws JsonProcessingException {
        Document.Builder builder = Document.newBuilder();
        Iterator iterator = node.fieldNames();
        ObjectMapper mapper = new ObjectMapper();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"id", (CharSequence)name)) {
                builder.withId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"vector", (CharSequence)name)) {
                List vector = (List)mapper.readValue(ele.toString(), (TypeReference)new TypeReference<List<Double>>(){});
                builder.withVector(vector);
                continue;
            }
            if (StringUtils.equals((CharSequence)"doc", (CharSequence)name)) {
                builder.withDoc(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"score", (CharSequence)name)) {
                builder.withScore(ele.asDouble());
                continue;
            }
            if (ele.isInt()) {
                builder.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addFilterField(new DocField(name, ele.isLong()));
                continue;
            }
            builder.addFilterField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }
}

