/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.param.collectionView.CreateCollectionViewParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.DataBaseType;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import java.util.List;
import java.util.Map;

public class AIDatabase {
    private final Stub stub;
    private final String databaseName;
    @JsonIgnore
    private final ReadConsistencyEnum readConsistency;

    public AIDatabase(Stub stub, String databaseName, ReadConsistencyEnum readConsistency) {
        this.stub = stub;
        this.databaseName = databaseName;
        this.readConsistency = readConsistency;
    }

    private void ensureDataBaseType() throws VectorDBException {
        Map<String, DataBaseType> dataBaseTypeMap = this.stub.listDatabaseInfos();
        if (!dataBaseTypeMap.containsKey(this.databaseName)) {
            throw new VectorDBException("database not existed");
        }
        if (!DataBaseTypeEnum.isAIDataBase(DataBaseTypeEnum.valueOf(dataBaseTypeMap.get(this.databaseName).getDbType()))) {
            throw new VectorDBException("database is not ai database");
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public AffectRes truncateCollectionView(String collectionViewName) {
        return this.stub.truncateCollectionView(this.databaseName, collectionViewName, DataBaseTypeEnum.AI_DB);
    }

    public List<CollectionView> listCollectionView() throws VectorDBException {
        List<CollectionView> collections = this.stub.listCollectionView(this.databaseName);
        collections.forEach(c -> {
            c.setStub(this.stub);
            c.setReadConsistency(this.readConsistency);
        });
        return collections;
    }

    public CollectionView createCollectionView(CreateCollectionViewParam param) throws VectorDBException {
        param.setDatabase(this.databaseName);
        param.setReadConsistency(this.readConsistency);
        this.stub.createCollectionView(param);
        param.setStub(this.stub);
        return param;
    }

    public CollectionView describeCollectionView(String collectionView) throws VectorDBException {
        CollectionView collection = this.stub.describeCollectionView(this.databaseName, collectionView);
        collection.setStub(this.stub);
        collection.setReadConsistency(this.readConsistency);
        return collection;
    }

    public AffectRes dropCollectionView(String collectionViewName) throws VectorDBException {
        return this.stub.dropCollectionView(this.databaseName, collectionViewName);
    }

    public AffectRes setAIAlias(String collectionViewName, String aliasName) {
        return this.stub.setAIAlias(this.databaseName, collectionViewName, aliasName);
    }

    public AffectRes deleteAIAlias(String aliasName) {
        return this.stub.deleteAIAlias(this.databaseName, aliasName);
    }

    public String toString() {
        return String.format("{\"database\":\"%s\"}", this.databaseName);
    }
}

