/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collectionView.EmbeddingParams;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.dml.CollectionViewConditionParam;
import com.tencent.tcvectordb.model.param.dml.CollectionViewQueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByContentsParam;
import com.tencent.tcvectordb.model.param.entity.AIStatus;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.DocumentFileContent;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewQueryParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewUpdateParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CollectionView {
    @JsonIgnore
    private Stub stub;
    private String database;
    protected String collectionView;
    @JsonIgnore
    protected ReadConsistencyEnum readConsistency;
    protected String description;
    private String createTime;
    private AIStatus stats;
    protected SplitterPreprocessParams splitterPreprocess;
    protected EmbeddingParams embedding;
    private List<String> alias;
    protected List<IndexField> indexes;

    public List<IndexField> getIndexes() {
        return this.indexes;
    }

    public String getCollectionView() {
        return this.collectionView;
    }

    public AIStatus getStats() {
        return this.stats;
    }

    public SplitterPreprocessParams getSplitterPreprocess() {
        return this.splitterPreprocess;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public Stub getStub() {
        return this.stub;
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ReadConsistencyEnum readConsistency) {
        this.readConsistency = readConsistency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public EmbeddingParams getEmbedding() {
        return this.embedding;
    }

    public void setEmbedding(EmbeddingParams embedding) {
        this.embedding = embedding;
    }

    public List<DocumentSet> query(CollectionViewQueryParam param) throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, param, this.readConsistency));
        documentSets.forEach(documentSet -> {
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        });
        return documentSets;
    }

    public List<DocumentSet> query() throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, CollectionViewQueryParam.newBuilder().build(), this.readConsistency));
        documentSets.forEach(documentSet -> {
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        });
        return documentSets;
    }

    public List<DocumentSet> query(int limit) throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, CollectionViewQueryParam.newBuilder().withLimit(limit).build(), this.readConsistency));
        documentSets.forEach(documentSet -> {
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        });
        return documentSets;
    }

    public List<DocumentSet> query(int limit, int offset) throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, CollectionViewQueryParam.newBuilder().withLimit(limit).withOffset(offset).build(), this.readConsistency));
        documentSets.forEach(documentSet -> {
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        });
        return documentSets;
    }

    public DocumentSet getDocumentSetByName(String documentSetName) throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, ((CollectionViewQueryParam.Builder)CollectionViewQueryParam.newBuilder().withDocumentSetNames((List)Arrays.asList(documentSetName))).build(), this.readConsistency));
        if (documentSets.size() > 0) {
            DocumentSet documentSet = documentSets.get(0);
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
            return documentSet;
        }
        throw new VectorDBException("data not existed!");
    }

    public DocumentSet getDocumentSetById(String documentSetId) throws VectorDBException {
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, this.collectionView, ((CollectionViewQueryParam.Builder)CollectionViewQueryParam.newBuilder().withDocumentSetIds((List)Arrays.asList(documentSetId))).build(), this.readConsistency));
        if (documentSets.size() > 0) {
            DocumentSet documentSet = documentSets.get(0);
            documentSet.setCollectionViewName(this.collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
            return documentSet;
        }
        throw new VectorDBException("data not existed!");
    }

    public List<SearchContentInfo> search(SearchByContentsParam param) throws VectorDBException {
        return this.stub.searchAIDocument(new SearchDocParamInner(this.database, this.collectionView, param, this.readConsistency)).getDocuments();
    }

    public AffectRes deleteDocumentSets(CollectionViewConditionParam param) throws VectorDBException {
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, this.collectionView, param));
    }

    public AffectRes deleteByDocumentSetName(String documentSetName) throws VectorDBException {
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, this.collectionView, CollectionViewConditionParam.newBuilder().withDocumentSetNames(Arrays.asList(documentSetName)).build()));
    }

    public AffectRes deleteByDocumentSetId(String documentSetId) throws VectorDBException {
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, this.collectionView, CollectionViewConditionParam.newBuilder().withDocumentSetIds(Arrays.asList(documentSetId)).build()));
    }

    public AffectRes update(CollectionViewConditionParam param, Map<String, Object> updateFieldValues) throws VectorDBException {
        return this.stub.updateAIDocument(new CollectionViewUpdateParamInner(this.database, this.collectionView, param, updateFieldValues));
    }

    public void loadAndSplitText(LoadAndSplitTextParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        this.stub.upload(this.database, this.collectionView, loadAndSplitTextParam.getDocumentSetName(), loadAndSplitTextParam.getLocalFilePath(), metaDataMap);
    }

    public void loadAndSplitText(LoadAndSplitTextParam loadAndSplitTextParam) throws Exception {
        this.stub.upload(this.database, this.collectionView, loadAndSplitTextParam.getDocumentSetName(), loadAndSplitTextParam.getLocalFilePath(), Collections.EMPTY_MAP);
    }

    public DocumentFileContent getFile(String fileName, String fileId) {
        return this.stub.getFile(this.database, this.collectionView, fileName, fileId).getDocumentSet();
    }

    public BaseRes rebuildIndex(RebuildIndexParam rebuildIndexParam) throws VectorDBException {
        return this.stub.rebuildAIIndex(new RebuildIndexParamInner(this.database, this.collectionView, rebuildIndexParam));
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new ParamException(String.format("Create collection param error: %s", new Object[]{e}));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IndexStatus {
        private String status;
        private Date startTime;

        public String getStatus() {
            return this.status;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return "IndexStatus{status='" + this.status + '\'' + ", startTime=" + this.startTime + '}';
        }
    }
}

