/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.collection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateCollectionParam
extends Collection {
    private CreateCollectionParam(Builder builder) {
        this.collection = builder.name;
        this.replicaNum = builder.replicaNum;
        this.shardNum = builder.shardNum;
        this.description = builder.description;
        this.indexes = builder.indexes;
        this.embedding = builder.embedding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class Builder {
        private String name;
        private int replicaNum = 2;
        private int shardNum = 1;
        private String description;
        private Embedding embedding;
        private final List<IndexField> indexes = new ArrayList<IndexField>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withReplicaNum(int replicaNum) {
            this.replicaNum = replicaNum;
            return this;
        }

        public Builder withShardNum(int shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addField(IndexField field) {
            this.indexes.add(field);
            return this;
        }

        public Builder withEmbedding(Embedding embedding) {
            this.embedding = embedding;
            return this;
        }

        public CreateCollectionParam build() throws ParamException {
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                throw new ParamException("ConnectParam error: name is null");
            }
            if (this.indexes.isEmpty()) {
                throw new ParamException("ConnectParam error: indexes is empty");
            }
            return new CreateCollectionParam(this);
        }
    }
}

