/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.collectionView;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collectionView.EmbeddingParams;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateCollectionViewParam
extends CollectionView {
    private CreateCollectionViewParam(Builder builder) {
        this.collectionView = builder.name;
        this.description = builder.description;
        this.splitterPreprocess = builder.splitterPreprocess;
        this.embedding = builder.embedding;
        this.indexes = builder.indexes;
    }

    @Override
    public SplitterPreprocessParams getSplitterPreprocess() {
        return this.splitterPreprocess;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class Builder {
        private String name;
        private String description;
        private final List<IndexField> indexes = new ArrayList<IndexField>();
        private SplitterPreprocessParams splitterPreprocess;
        private EmbeddingParams embedding;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addField(IndexField field) {
            this.indexes.add(field);
            return this;
        }

        public Builder withEmbedding(EmbeddingParams embedding) {
            this.embedding = embedding;
            return this;
        }

        public Builder withSplitterPreprocess(SplitterPreprocessParams documentPreprocess) {
            this.splitterPreprocess = documentPreprocess;
            return this;
        }

        public CreateCollectionViewParam build() throws ParamException {
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                throw new ParamException("ConnectParam error: name is null");
            }
            return new CreateCollectionViewParam(this);
        }
    }
}

