/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.model.param.dml.CollectionViewConditionParam;
import com.tencent.tcvectordb.model.param.dml.Filter;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CollectionViewQueryParam
extends CollectionViewConditionParam {
    private List<String> outputFields;
    private Integer limit;
    private Integer offset;

    public CollectionViewQueryParam(Builder builder) {
        this.documentSetName = builder.documentSetNames;
        this.documentSetId = builder.documentSetIds;
        this.filter = builder.filter;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.outputFields = builder.outputFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public List<String> getDocumentSetId() {
        return this.documentSetId;
    }

    @Override
    public void setDocumentSetId(List<String> documentSetId) {
        this.documentSetId = documentSetId;
    }

    @Override
    public List<String> getDocumentSetName() {
        return this.documentSetName;
    }

    @Override
    public void setDocumentSetName(List<String> documentSetName) {
        this.documentSetName = documentSetName;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public static class Builder
    extends CollectionViewConditionParam.Builder {
        private Integer limit;
        private Integer offset;
        private List<String> outputFields;
        private List<String> documentSetIds;
        private List<String> documentSetNames;
        private String filter;

        @Override
        public Builder withDocumentSetIds(List<String> documentSetIds) {
            this.documentSetIds = documentSetIds;
            return this;
        }

        @Override
        public Builder withDocumentSetNames(List<String> documentSetNames) {
            this.documentSetNames = documentSetNames;
            return this;
        }

        @Override
        public Builder withDocumentSetIds(String ... documentSetIds) {
            if (documentSetIds == null || documentSetIds.length == 0) {
                return this;
            }
            this.documentSetIds = Arrays.asList(documentSetIds);
            return this;
        }

        @Override
        public Builder withDocumentSetNames(String ... documentSetNames) {
            if (documentSetNames == null || documentSetNames.length == 0) {
                return this;
            }
            this.documentSetNames = Arrays.asList(documentSetNames);
            return this;
        }

        @Override
        public Builder withFilter(Filter filter) {
            this.filter = filter.getCond();
            return this;
        }

        public Builder withLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder withOffset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder withOutputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        @Override
        public CollectionViewQueryParam build() {
            return new CollectionViewQueryParam(this);
        }
    }
}

