/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import java.util.List;

public class DocField {
    private final String name;
    private final Object value;

    public DocField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getStringValue() {
        return this.value.toString();
    }

    @JsonIgnore
    public FieldType getFieldType() {
        if (this.value == null) {
            throw new VectorDBException("DocField value is null, filed name is " + this.name);
        }
        String valueClassName = this.value.getClass().getName();
        if (valueClassName.equals("java.lang.Integer") || valueClassName.equals("java.lang.Long")) {
            return FieldType.Uint64;
        }
        if (this.value instanceof List) {
            return FieldType.Array;
        }
        return FieldType.String;
    }
}

