/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.model.DocField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Document {
    private String id;
    private List<Double> vector;
    private Double score;
    private String doc;
    private List<DocField> docFields;
    private Map<String, Object> docKeyValue;

    public String getId() {
        return this.id;
    }

    public Double getScore() {
        return this.score;
    }

    public String getDoc() {
        return this.doc;
    }

    public List<DocField> getDocFields() {
        return this.docFields;
    }

    public Map<String, Object> getDocKeyValue() {
        return this.docKeyValue;
    }

    public List<Double> getVector() {
        if (this.vector == null || this.vector.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.vector);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVector(List<Double> vector) {
        this.vector = vector;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public void setDocFields(List<DocField> docFields) {
        this.docFields = docFields;
    }

    public Object getObject(String key) {
        if (Objects.isNull(this.docFields) || this.docFields.isEmpty()) {
            return null;
        }
        this.ensureDocKeyValue();
        return this.docKeyValue.get(key);
    }

    private void ensureDocKeyValue() {
        if (Objects.isNull(this.docKeyValue)) {
            this.docKeyValue = new TreeMap<String, Object>();
            for (DocField docField : this.docFields) {
                this.docKeyValue.put(docField.getName(), docField.getValue());
            }
        }
    }

    public String toString() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            node.put("id", this.id);
        }
        if (this.vector != null && !this.vector.isEmpty()) {
            ArrayNode vectorNode = JsonNodeFactory.instance.arrayNode();
            this.vector.forEach(arg_0 -> ((ArrayNode)vectorNode).add(arg_0));
            node.set("vector", (JsonNode)vectorNode);
        }
        if (this.score != null) {
            node.put("score", this.score);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.doc)) {
            node.put("doc", this.doc);
        }
        if (this.docFields != null && !this.docFields.isEmpty()) {
            block4: for (DocField field : this.docFields) {
                switch (field.getFieldType()) {
                    case Uint64: {
                        node.put(field.getName(), Long.valueOf(field.getStringValue()));
                        continue block4;
                    }
                    case Array: {
                        List strValues = (List)field.getValue();
                        ArrayNode strNode = JsonNodeFactory.instance.arrayNode();
                        strValues.forEach(arg_0 -> ((ArrayNode)strNode).add(arg_0));
                        node.set(field.getName(), (JsonNode)strNode);
                        continue block4;
                    }
                }
                node.put(field.getName(), field.getStringValue());
            }
        }
        return node.toString();
    }

    private Document(Builder builder) {
        this.id = builder.id;
        this.vector = builder.vector;
        this.doc = builder.doc;
        this.score = builder.score;
        this.docFields = builder.docFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private List<Double> vector;
        private Double score;
        private String doc;
        private List<DocField> docFields = new ArrayList<DocField>();

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withVector(List<Double> vector) {
            this.vector = vector;
            return this;
        }

        public Builder withDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder withScore(Double score) {
            this.score = score;
            return this;
        }

        @Deprecated
        public Builder addFilterField(DocField field) {
            this.docFields.add(field);
            return this;
        }

        public Builder addDocField(DocField docField) {
            this.docFields.add(docField);
            return this;
        }

        public Builder addDocFields(List<DocField> docFields) {
            this.docFields.addAll(docFields);
            return this;
        }

        public Document build() {
            return new Document(this);
        }
    }
}

