/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.dml.CollectionViewConditionParam;
import com.tencent.tcvectordb.model.param.dml.SearchByContentsParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.DocumentSetInfo;
import com.tencent.tcvectordb.model.param.entity.GetChunksRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentSet {
    @JsonIgnore
    private Stub stub;
    private String database;
    protected String collectionViewName;
    private ReadConsistencyEnum readConsistency = ReadConsistencyEnum.EVENTUAL_CONSISTENCY;
    private String documentSetId;
    private String documentSetName;
    private String textPrefix;
    private DocumentSetInfo documentSetInfo;
    private List<DocField> docFields;
    private Map<String, Object> docKeyValue;
    private SplitterPreprocessParams splitterPreprocess;

    public SplitterPreprocessParams getSplitterPreprocess() {
        return this.splitterPreprocess;
    }

    public void setSplitterPreprocess(SplitterPreprocessParams splitterPreprocess) {
        this.splitterPreprocess = splitterPreprocess;
    }

    public List<DocField> getDocFields() {
        return this.docFields;
    }

    public Map<String, Object> getDocKeyValue() {
        return this.docKeyValue;
    }

    public void setDocFields(List<DocField> docFields) {
        this.docFields = docFields;
    }

    public Object getObject(String key) {
        if (Objects.isNull(this.docFields) || this.docFields.isEmpty()) {
            return null;
        }
        this.ensureDocKeyValue();
        return this.docKeyValue.get(key);
    }

    private void ensureDocKeyValue() {
        if (Objects.isNull(this.docKeyValue)) {
            this.docKeyValue = new TreeMap<String, Object>();
            for (DocField docField : this.docFields) {
                this.docKeyValue.put(docField.getName(), docField.getValue());
            }
        }
    }

    public List<SearchContentInfo> search(SearchByContentsParam param) throws VectorDBException {
        param.setDocumentSetName(Arrays.asList(this.documentSetName));
        return this.stub.searchAIDocument(new SearchDocParamInner(this.database, this.collectionViewName, param, this.readConsistency)).getDocuments();
    }

    public GetChunksRes getChunks() throws VectorDBException {
        return this.stub.getChunks(this.database, this.collectionViewName, this.documentSetName, this.documentSetId, null, null);
    }

    public GetChunksRes getChunks(Integer limit) throws VectorDBException {
        return this.stub.getChunks(this.database, this.collectionViewName, this.documentSetName, this.documentSetId, limit, null);
    }

    public GetChunksRes getChunks(Integer limit, Integer offset) throws VectorDBException {
        return this.stub.getChunks(this.database, this.collectionViewName, this.documentSetName, this.documentSetId, limit, offset);
    }

    public AffectRes delete() throws VectorDBException {
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, this.collectionViewName, CollectionViewConditionParam.newBuilder().withDocumentSetIds(Arrays.asList(this.documentSetId)).build()));
    }

    public String getText() {
        return this.stub.getFile(this.database, this.collectionViewName, this.documentSetName, this.documentSetId).getDocumentSet().getText();
    }

    public Stub getStub() {
        return this.stub;
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollectionViewName() {
        return this.collectionViewName;
    }

    public void setCollectionViewName(String collectionViewname) {
        this.collectionViewName = collectionViewname;
    }

    public DocumentSetInfo getDocumentSetInfo() {
        return this.documentSetInfo;
    }

    public String toString() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (StringUtils.isNotBlank((CharSequence)this.documentSetId)) {
            node.put("documentSetId", this.documentSetId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.documentSetName)) {
            node.put("documentSetName", this.documentSetName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.textPrefix)) {
            node.put("textPrefix", this.textPrefix);
        }
        if (this.documentSetInfo != null) {
            node.put("documentSetInfo", JsonUtils.toJsonString(this.documentSetInfo));
        }
        if (this.splitterPreprocess != null) {
            node.put("splitterPreprocess", JsonUtils.toJsonString(this.splitterPreprocess));
        }
        if (this.docFields != null && !this.docFields.isEmpty()) {
            block4: for (DocField field : this.docFields) {
                switch (field.getFieldType()) {
                    case Uint64: {
                        node.put(field.getName(), Long.valueOf(field.getValue().toString()));
                        continue block4;
                    }
                    case Array: {
                        List strValues = (List)field.getValue();
                        ArrayNode strNode = JsonNodeFactory.instance.arrayNode();
                        strValues.forEach(arg_0 -> ((ArrayNode)strNode).add(arg_0));
                        node.set(field.getName(), (JsonNode)strNode);
                    }
                }
                node.put(field.getName(), field.getStringValue());
            }
        }
        return node.toString();
    }

    private DocumentSet(Builder builder) {
        this.docFields = builder.docFields;
        this.documentSetInfo = builder.documentSetInfo;
        this.documentSetName = builder.documnetSetName;
        this.documentSetId = builder.documentSetId;
        this.textPrefix = builder.textPrefix;
        this.splitterPreprocess = builder.splitterPreprocess;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String documentSetId;
        private String documnetSetName;
        private String textPrefix;
        private DocumentSetInfo documentSetInfo;
        private List<DocField> docFields = new ArrayList<DocField>();
        private SplitterPreprocessParams splitterPreprocess;

        public Builder withDocumentSetId(String documentSetId) {
            this.documentSetId = documentSetId;
            return this;
        }

        public Builder withDocumnetSetName(String documnetSetName) {
            this.documnetSetName = documnetSetName;
            return this;
        }

        public Builder withTextPrefix(String textPrefix) {
            this.textPrefix = textPrefix;
            return this;
        }

        public Builder withDocumentSetInfo(DocumentSetInfo documentSetInfo) {
            this.documentSetInfo = documentSetInfo;
            return this;
        }

        public Builder withSplitProcess(SplitterPreprocessParams splitterPreprocess) {
            this.splitterPreprocess = splitterPreprocess;
            return this;
        }

        @Deprecated
        public Builder addFilterField(DocField field) {
            this.docFields.add(field);
            return this;
        }

        public Builder addDocField(DocField docField) {
            this.docFields.add(docField);
            return this;
        }

        public Builder addDocFields(List<DocField> docFields) {
            this.docFields.addAll(docFields);
            return this;
        }

        public DocumentSet build() {
            return new DocumentSet(this);
        }
    }
}

