/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.param.dml.SearchOption;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchByContentsParam {
    private String content;
    private SearchOption options;
    private String filter;
    private List<String> documentSetName;
    private Integer limit;

    public SearchOption getOptions() {
        return this.options;
    }

    public void setOptions(SearchOption options) {
        this.options = options;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public List<String> getDocumentSetName() {
        return this.documentSetName;
    }

    public void setDocumentSetName(List<String> documentSetName) {
        this.documentSetName = documentSetName;
    }

    private SearchByContentsParam(Builder builder) {
        this.content = builder.content;
        this.options = builder.searchOption;
        this.filter = builder.filter;
        this.limit = builder.limit;
        this.documentSetName = builder.documentSetName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String content = "";
        private SearchOption searchOption;
        private String filter;
        protected Integer limit;
        private List<String> documentSetName;

        private Builder() {
        }

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withSearchContentOption(SearchOption searchOption) {
            this.searchOption = searchOption;
            return this;
        }

        public Builder withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder withDocumentSetName(List<String> documentSetName) {
            this.documentSetName = documentSetName;
            return this;
        }

        public Builder withDocumentSetName(String ... documentSetName) {
            if (documentSetName == null || documentSetName.length == 0) {
                return this;
            }
            this.documentSetName = Arrays.asList(documentSetName);
            return this;
        }

        public SearchByContentsParam build() {
            if (this.content.isEmpty()) {
                throw new ParamException("SearchByContentsParam error: content is empty");
            }
            return new SearchByContentsParam(this);
        }
    }
}

