/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import com.tencent.tcvectordb.enums.Code;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.AIDatabase;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collectionView.CreateCollectionViewParam;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.ContentInfo;
import com.tencent.tcvectordb.model.param.entity.DataBaseType;
import com.tencent.tcvectordb.model.param.entity.DataBaseTypeRes;
import com.tencent.tcvectordb.model.param.entity.DocumentFileContent;
import com.tencent.tcvectordb.model.param.entity.DocumentSetInfo;
import com.tencent.tcvectordb.model.param.entity.GetChunksRes;
import com.tencent.tcvectordb.model.param.entity.GetDocumentSetRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.model.param.entity.SearchContentRes;
import com.tencent.tcvectordb.model.param.entity.SearchDocumentSetInfo;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.entity.UploadUrlRes;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewQueryParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewUpdateParamInner;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import com.tencent.tcvectordb.utils.FileUtils;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStub
implements Stub {
    private final ConnectParam connectParam;
    private final OkHttpClient client;
    private final Headers headers;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger((String)HttpStub.class.getName());

    public HttpStub(ConnectParam connectParam) {
        this.connectParam = connectParam;
        String authorization = String.format("Bearer account=%s&api_key=%s", connectParam.getUsername(), connectParam.getKey());
        this.headers = new Headers.Builder().add("Authorization", authorization).build();
        logger.debug("header: {}", (Object)authorization);
        this.client = new OkHttpClient.Builder().connectTimeout(this.connectParam.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)connectParam.getTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(this.connectParam.getMaxIdleConnections(), (long)this.connectParam.getKeepAliveDuration(), TimeUnit.SECONDS)).build();
    }

    @Override
    public void createDatabase(Database database) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/create");
        this.post(url, database.toString());
    }

    @Override
    public void dropDatabase(Database database) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/drop");
        this.post(url, database.toString());
    }

    @Override
    public AffectRes createAIDatabase(AIDatabase aiDatabase) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/database/create");
        JsonNode jsonNode = this.post(url, aiDatabase.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public DataBaseTypeRes describeDatabase(Database database) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/describe");
        String body = String.format("{\"database\":\"%s\"}", database.getDatabaseName());
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), DataBaseTypeRes.class);
    }

    @Override
    public AffectRes dropAIDatabase(AIDatabase aiDatabase) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/database/drop");
        JsonNode jsonNode = this.post(url, aiDatabase.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<String> listDatabases() {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/list");
        JsonNode jsonNode = this.get(url);
        JsonNode dbsJson = jsonNode.get("databases");
        if (dbsJson == null) {
            return new ArrayList<String>();
        }
        try {
            return (List)this.mapper.readValue(dbsJson.toString(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response error: can't parse databases=%s", dbsJson));
        }
    }

    @Override
    public Map<String, DataBaseType> listDatabaseInfos() {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/database/list");
        JsonNode jsonNode = this.get(url);
        JsonNode dbsJson = jsonNode.get("info");
        if (dbsJson == null) {
            return new HashMap<String, DataBaseType>();
        }
        try {
            return (Map)this.mapper.readValue(dbsJson.toString(), (TypeReference)new TypeReference<Map<String, DataBaseType>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response error: can't parse databases=%s", dbsJson));
        }
    }

    @Override
    public void createCollection(CreateCollectionParam param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/create");
        this.post(url, param.toString());
    }

    @Override
    public void createCollectionView(CreateCollectionViewParam params) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/collectionView/create");
        this.post(url, params.toString());
    }

    @Override
    public List<Collection> listCollections(String databaseName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/list");
        JsonNode jsonNode = this.post(url, String.format("{\"database\":\"%s\"}", databaseName));
        JsonNode closJson = jsonNode.get("collections");
        if (closJson == null) {
            return new ArrayList<Collection>();
        }
        return JsonUtils.collectionDeserializer(closJson.toString(), new TypeReference<List<Collection>>(){});
    }

    @Override
    public Collection describeCollection(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/describe");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        JsonNode dbsJson = jsonNode.get("collection");
        if (dbsJson == null) {
            return null;
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<Collection>(){});
    }

    @Override
    public AffectRes truncateCollection(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/truncate");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes truncateCollectionView(String databaseName, String collectionName, DataBaseTypeEnum dbType) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/collectionView/truncate");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public void dropCollection(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/collection/drop");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\"}", databaseName, collectionName);
        this.post(url, body);
    }

    @Override
    public AffectRes setAlias(String databaseName, String collectionName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/alias/set");
        String body = String.format("{\"database\":\"%s\",\"collection\":\"%s\",\"alias\":\"%s\"}", databaseName, collectionName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes deleteAlias(String databaseName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/alias/delete");
        String body = String.format("{\"database\":\"%s\",\"alias\":\"%s\"}", databaseName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes upsertDocument(InsertParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/upsert");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<Document> queryDocument(QueryParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/query");
        JsonNode jsonNode = this.post(url, param.toString());
        JsonNode docsNode = jsonNode.get("documents");
        ArrayList<Document> dosc = new ArrayList<Document>();
        if (docsNode == null) {
            return dosc;
        }
        try {
            Iterator iterator = docsNode.elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                Document doc = this.node2Doc(node);
                dosc.add(doc);
            }
            return dosc;
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from query error: can't parse documents=%s", docsNode));
        }
    }

    @Override
    public SearchRes searchDocument(SearchParamInner param, DataBaseTypeEnum dbType) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/search");
        if (DataBaseTypeEnum.isAIDataBase(dbType)) {
            url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/search");
        }
        JsonNode jsonNode = this.post(url, param.toString());
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new SearchRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList<List<Document>> multiDosc = new ArrayList<List<Document>>();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                Iterator iter = docNode.elements();
                ArrayList<Document> docs = new ArrayList<Document>();
                while (iter.hasNext()) {
                    JsonNode node = (JsonNode)iter.next();
                    Document doc = this.node2Doc(node);
                    docs.add(doc);
                }
                multiDosc.add(docs);
            }
            return new SearchRes(code, msg, warning, multiDosc);
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public AffectRes deleteDocument(DeleteParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/delete");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes updateDocument(UpdateParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/document/update");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public BaseRes rebuildIndex(RebuildIndexParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/index/rebuild");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public BaseRes rebuildAIIndex(RebuildIndexParamInner param) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/index/rebuild");
        JsonNode jsonNode = this.post(url, param.toString());
        return JsonUtils.parseObject(jsonNode.toString(), BaseRes.class);
    }

    @Override
    public AffectRes setAIAlias(String databaseName, String collectionName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/alias/set");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\",\"alias\":\"%s\"}", databaseName, collectionName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public AffectRes deleteAIAlias(String databaseName, String aliasName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/alias/delete");
        String body = String.format("{\"database\":\"%s\",\"alias\":\"%s\"}", databaseName, aliasName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<CollectionView> listCollectionView(String databaseName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/collectionView/list");
        JsonNode jsonNode = this.post(url, String.format("{\"database\":\"%s\"}", databaseName));
        JsonNode closJson = jsonNode.get("collectionViews");
        if (closJson == null) {
            return new ArrayList<CollectionView>();
        }
        return JsonUtils.collectionDeserializer(closJson.toString(), new TypeReference<List<CollectionView>>(){});
    }

    @Override
    public CollectionView describeCollectionView(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/collectionView/describe");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        JsonNode dbsJson = jsonNode.get("collectionView");
        if (dbsJson == null) {
            return null;
        }
        return JsonUtils.collectionDeserializer(dbsJson.toString(), new TypeReference<CollectionView>(){});
    }

    @Override
    public AffectRes dropCollectionView(String databaseName, String collectionName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/collectionView/drop");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\"}", databaseName, collectionName);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public List<DocumentSet> queryAIDocument(CollectionViewQueryParamInner queryParamInner) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/query");
        JsonNode jsonNode = this.post(url, queryParamInner.toString());
        JsonNode docsNode = jsonNode.get("documentSets");
        ArrayList<DocumentSet> dosc = new ArrayList<DocumentSet>();
        if (docsNode == null) {
            return dosc;
        }
        try {
            Iterator iterator = docsNode.elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                DocumentSet doc = this.node2DocmentSet(node);
                dosc.add(doc);
            }
            return dosc;
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from query error: can't parse documents=%s", docsNode));
        }
    }

    @Override
    public AffectRes deleteAIDocument(CollectionViewDeleteParamInner deleteParamInner) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/delete");
        JsonNode jsonNode = this.post(url, deleteParamInner.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    @Override
    public SearchContentRes searchAIDocument(SearchDocParamInner searchDocParamInner) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/search");
        JsonNode jsonNode = this.post(url, searchDocParamInner.toString());
        JsonNode multiDocsNode = jsonNode.get("documents");
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        if (multiDocsNode == null) {
            return new SearchContentRes(code, msg, warning, Collections.emptyList());
        }
        try {
            ArrayList<SearchContentInfo> multiDosc = new ArrayList<SearchContentInfo>();
            Iterator multiIter = multiDocsNode.elements();
            while (multiIter.hasNext()) {
                JsonNode docNode = (JsonNode)multiIter.next();
                SearchContentInfo doc = this.node2SearchDoc(docNode);
                multiDosc.add(doc);
            }
            return new SearchContentRes(code, msg, warning, multiDosc);
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
    }

    @Override
    public AffectRes updateAIDocument(CollectionViewUpdateParamInner updateParamInner) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/update");
        JsonNode jsonNode = this.post(url, updateParamInner.toString());
        return JsonUtils.parseObject(jsonNode.toString(), AffectRes.class);
    }

    public UploadUrlRes getUploadUrl(String databaseName, String collectionViewName, String documentSetName, String fileName) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/uploadUrl");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database", databaseName);
        params.put("collectionView", collectionViewName);
        if (documentSetName != null) {
            params.put("documentSetName", documentSetName);
        } else if (fileName != null) {
            params.put("documentSetName", fileName);
        }
        String body = JsonUtils.toJsonString(params);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.collectionDeserializer(jsonNode.toString(), new TypeReference<UploadUrlRes>(){});
    }

    @Override
    public void upload(String databaseName, String collectionViewName, LoadAndSplitTextParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        File file = new File(loadAndSplitTextParam.getLocalFilePath());
        if (!file.exists() || !file.isFile()) {
            throw new VectorDBException("file is not existed");
        }
        if (file.length() <= 0L) {
            throw new VectorDBException("file is empty");
        }
        UploadUrlRes uploadUrlRes = this.getUploadUrl(databaseName, collectionViewName, loadAndSplitTextParam.getDocumentSetName(), file.getName());
        if (Code.isFailed(uploadUrlRes.getCode()) || uploadUrlRes.getCredentials() == null || uploadUrlRes.getCredentials().getTmpSecretId().equals("") || uploadUrlRes.getUploadCondition() == null || uploadUrlRes.getUploadCondition().getMaxSupportContentLength() == 0) {
            String msg = StringUtils.isNotBlank((CharSequence)uploadUrlRes.getMsg()) ? ", " + uploadUrlRes.getMsg() : "";
            throw new VectorDBException("get file upload url failed" + msg);
        }
        String filePath = loadAndSplitTextParam.getLocalFilePath();
        int maxLength = uploadUrlRes.getUploadCondition().getMaxSupportContentLength();
        if (file.length() > (long)maxLength) {
            throw new ParamException(String.format("%s file is too large, max size is %d bytes", filePath, maxLength));
        }
        String uploadPath = uploadUrlRes.getUploadPath();
        String bucket = uploadUrlRes.getCosBucket();
        String region = uploadUrlRes.getCosRegion();
        BasicSessionCredentials cred = new BasicSessionCredentials(uploadUrlRes.getCredentials().getTmpSecretId(), uploadUrlRes.getCredentials().getTmpSecretKey(), uploadUrlRes.getCredentials().getToken());
        ClientConfig cosClientConfig = new ClientConfig(new Region(region));
        COSClient cosClient = new COSClient((COSCredentials)cred, cosClientConfig);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, uploadPath, file);
        ObjectMetadata metadata = new ObjectMetadata();
        String fileType = FileUtils.getFileType(file);
        if (!"md".equals(fileType) && Objects.nonNull(loadAndSplitTextParam.getSplitterProcess()) && StringUtils.isNotEmpty((CharSequence)loadAndSplitTextParam.getSplitterProcess().getChunkSplitter())) {
            logger.warn("only markdown files are allowed to use chunkSplitter");
        }
        metadata.addUserMetadata("fileType", fileType);
        metadata.addUserMetadata("id", uploadUrlRes.getDocumentSetId());
        if (metaDataMap == null || metaDataMap.isEmpty()) {
            metaDataMap = new HashMap<String, Object>();
        }
        String metaJson = URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(metaDataMap).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8));
        metadata.addUserMetadata("data", metaJson);
        if (loadAndSplitTextParam.getSplitterProcess() != null) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("appendTitleToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendTitleToChunk());
            config.put("appendKeywordsToChunk", loadAndSplitTextParam.getSplitterProcess().isAppendKeywordsToChunk());
            if (loadAndSplitTextParam.getSplitterProcess().getChunkSplitter() != null) {
                config.put("chunkSplitter", loadAndSplitTextParam.getSplitterProcess().getChunkSplitter());
            }
            metadata.addUserMetadata("config", URLEncoder.encode(Base64.getEncoder().encodeToString(JsonUtils.toJsonString(config).getBytes(StandardCharsets.UTF_8)), String.valueOf(StandardCharsets.UTF_8)));
        }
        if (JsonUtils.toJsonString(metadata).length() > 2048) {
            throw new VectorDBException("cos header for param MetaData is too large, it can not be more than 2k");
        }
        putObjectRequest.withMetadata(metadata);
        putObjectRequest.withKey(uploadPath);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        logger.debug("upload file, response:%s", (Object)JsonUtils.toJsonString(putObjectResult));
        cosClient.shutdown();
    }

    @Override
    public GetDocumentSetRes getFile(String databaseName, String collectionName, String documentSetName, String documentSetId) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/get");
        String body = String.format("{\"database\":\"%s\",\"collectionView\":\"%s\",\"documentSetName\":\"%s\",\"documentSetId\":\"%s\"}", databaseName, collectionName, documentSetName, documentSetId);
        JsonNode jsonNode = this.post(url, body);
        int code = 0;
        if (jsonNode.get("code") != null) {
            code = jsonNode.get("code").asInt();
        }
        String msg = "";
        if (jsonNode.get("msg") != null) {
            msg = jsonNode.get("msg").asText();
        }
        String warning = "";
        if (jsonNode.get("warning") != null) {
            warning = jsonNode.get("warning").asText();
        }
        int count = 0;
        if (jsonNode.get("count") != null) {
            count = jsonNode.get("count").asInt();
        }
        GetDocumentSetRes res = new GetDocumentSetRes(code, msg, warning, count);
        JsonNode multiDocsNode = jsonNode.get("documentSet");
        if (multiDocsNode == null) {
            return res;
        }
        try {
            res.setDocumentSet(this.node2DocumentFileContent(multiDocsNode));
        }
        catch (JsonProcessingException ex) {
            throw new VectorDBException(String.format("VectorDBServer response from search error: can't parse documents=%s", multiDocsNode));
        }
        return res;
    }

    @Override
    public GetChunksRes getChunks(String databaseName, String collectionName, String documentSetName, String documentSetId, Integer limit, Integer offset) {
        String url = String.format("%s%s", this.connectParam.getUrl(), "/ai/documentSet/getChunks");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("database", databaseName);
        params.put("collectionView", collectionName);
        if (documentSetName != null) {
            params.put("documentSetName", documentSetName);
        }
        if (documentSetId != null) {
            params.put("documentSetId", documentSetId);
        }
        if (limit != null) {
            params.put("limit", limit);
        }
        if (offset != null) {
            params.put("offset", offset);
        }
        String body = JsonUtils.toJsonString(params);
        JsonNode jsonNode = this.post(url, body);
        return JsonUtils.collectionDeserializer(jsonNode.toString(), new TypeReference<GetChunksRes>(){});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode get(String url) {
        Request request = new Request.Builder().url(url).headers(this.headers).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            throw new VectorDBException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode post(String url, String json) {
        logger.debug("Query {}, body={}", (Object)url, (Object)json);
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url(url).headers(this.headers).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            JsonNode jsonNode = this.parseResponse(response);
            return jsonNode;
        }
        catch (IOException ex) {
            logger.error("VectorDBServer IOException", (Throwable)ex);
            throw new VectorDBException(String.format("VectorDBServer IOException: %s", ex.getMessage()));
        }
    }

    private JsonNode parseResponse(Response response) throws IOException {
        ResponseBody resBody = response.body();
        if (resBody == null) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody null, http code=%s, message=%s", response.code(), response.message()));
        }
        String resStr = resBody.string();
        logger.debug("Query {}, code={}, msg={}, result={}", new Object[]{response.request().url(), response.code(), response.message(), resStr});
        if (StringUtils.isEmpty((CharSequence)resStr)) {
            throw new VectorDBException(String.format("VectorDBServer error: ResponseBody empty, http code=%s, message=%s", response.code(), response.message()));
        }
        if (!response.isSuccessful()) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, http code=%s, message=%s, result=%s", response.code(), response.message(), resStr));
        }
        JsonNode jsonNode = this.mapper.readTree(resStr);
        int code = jsonNode.get("code").asInt();
        if (code != 0) {
            throw new VectorDBException(String.format("VectorDBServer error: not Successful, body code=%s, message=%s", code, jsonNode.get("msg").asText()));
        }
        return jsonNode;
    }

    private SearchContentInfo node2SearchDoc(JsonNode node) throws JsonProcessingException {
        SearchContentInfo.Builder builder = SearchContentInfo.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"score", (CharSequence)name)) {
                builder.withScore(ele.asDouble());
                continue;
            }
            if (StringUtils.equals((CharSequence)"data", (CharSequence)name)) {
                builder.withSearchContentInfo(JsonUtils.parseObject(ele.toString(), ContentInfo.class));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"documentSet", (CharSequence)name)) continue;
            builder.withSearchDocumentSetInfo(this.node2SearchDocumentSet(ele));
        }
        return builder.build();
    }

    private SearchDocumentSetInfo node2SearchDocumentSet(JsonNode node) throws JsonProcessingException {
        SearchDocumentSetInfo.Builder builder = SearchDocumentSetInfo.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                builder.withDocumentSetName(ele.toString());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                builder.withDocumentSetId(ele.toString());
                continue;
            }
            if (ele.isInt()) {
                builder.addDocField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addDocField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addDocField(new DocField(name, values));
                continue;
            }
            builder.addDocField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private Document node2Doc(JsonNode node) throws JsonProcessingException {
        Document.Builder builder = Document.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"id", (CharSequence)name)) {
                builder.withId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"vector", (CharSequence)name)) {
                List vector = JsonUtils.parseObject(ele.toString(), List.class);
                builder.withVector(vector);
                continue;
            }
            if (StringUtils.equals((CharSequence)"doc", (CharSequence)name)) {
                builder.withDoc(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"score", (CharSequence)name)) {
                builder.withScore(ele.asDouble());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSet", (CharSequence)name)) {
                builder.addFilterField(new DocField(name, this.node2Doc(ele)));
                continue;
            }
            if (ele.isInt()) {
                builder.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addFilterField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addFilterField(new DocField(name, values));
                continue;
            }
            builder.addFilterField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private DocumentSet node2DocmentSet(JsonNode node) throws JsonProcessingException {
        DocumentSet.Builder builder = DocumentSet.newBuilder();
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                builder.withDocumentSetId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetInfo", (CharSequence)name)) {
                DocumentSetInfo documentSetInfo = JsonUtils.parseObject(ele.toString(), DocumentSetInfo.class);
                builder.withDocumentSetInfo(documentSetInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                builder.withDocumnetSetName(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"textPrefix", (CharSequence)name)) {
                builder.withTextPrefix(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"splitterPreprocess", (CharSequence)name)) {
                SplitterPreprocessParams splitterPreprocess = JsonUtils.parseObject(ele.toString(), SplitterPreprocessParams.class);
                builder.withSplitProcess(splitterPreprocess);
                continue;
            }
            if (ele.isInt()) {
                builder.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                builder.addFilterField(new DocField(name, ele.asLong()));
                builder.addFilterField(new DocField(name, ele.isLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                builder.addFilterField(new DocField(name, values));
                continue;
            }
            builder.addFilterField(new DocField(name, ele.asText()));
        }
        return builder.build();
    }

    private DocumentFileContent node2DocumentFileContent(JsonNode node) throws JsonProcessingException {
        DocumentFileContent documentFileContent = new DocumentFileContent();
        documentFileContent.setDocFields(new ArrayList<DocField>());
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            JsonNode ele = node.get(name);
            if (StringUtils.equals((CharSequence)"documentSetId", (CharSequence)name)) {
                documentFileContent.setDocumentSetId(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetInfo", (CharSequence)name)) {
                DocumentSetInfo documentSetInfo = JsonUtils.parseObject(ele.toString(), DocumentSetInfo.class);
                documentFileContent.setDocumentSetInfo(documentSetInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)"documentSetName", (CharSequence)name)) {
                documentFileContent.setDocumentSetName(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"text", (CharSequence)name)) {
                documentFileContent.setText(ele.asText());
                continue;
            }
            if (StringUtils.equals((CharSequence)"splitterPreprocess", (CharSequence)name)) {
                SplitterPreprocessParams splitterPreprocess = JsonUtils.parseObject(ele.toString(), SplitterPreprocessParams.class);
                documentFileContent.setSplitterPreprocess(splitterPreprocess);
                continue;
            }
            if (ele.isInt()) {
                documentFileContent.addFilterField(new DocField(name, ele.asInt()));
                continue;
            }
            if (ele.isLong()) {
                documentFileContent.addFilterField(new DocField(name, ele.asLong()));
                continue;
            }
            if (ele.isArray()) {
                List values = JsonUtils.parseObject(ele.toString(), List.class);
                documentFileContent.addFilterField(new DocField(name, values));
                continue;
            }
            documentFileContent.addFilterField(new DocField(name, ele.asText()));
        }
        return documentFileContent;
    }
}

