/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.client;

import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.AIDatabase;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.UploadFileParam;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.dml.AddIndexParam;
import com.tencent.tcvectordb.model.param.dml.CountQueryParam;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.GetImageUrlParam;
import com.tencent.tcvectordb.model.param.dml.HybridSearchParam;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.ModifyVectorIndexParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.GetImageUrlRes;
import com.tencent.tcvectordb.model.param.entity.HybridSearchRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.model.param.user.UserChangePasswordParam;
import com.tencent.tcvectordb.model.param.user.UserCreateParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeParam;
import com.tencent.tcvectordb.model.param.user.UserDescribeRes;
import com.tencent.tcvectordb.model.param.user.UserDropParam;
import com.tencent.tcvectordb.model.param.user.UserGrantParam;
import com.tencent.tcvectordb.model.param.user.UserListRes;
import com.tencent.tcvectordb.model.param.user.UserRevokeParam;
import com.tencent.tcvectordb.service.HttpStub;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.AddIndexParamInner;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.DropIndexParamInner;
import com.tencent.tcvectordb.service.param.GetImageUrlParamInner;
import com.tencent.tcvectordb.service.param.HybridSearchParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.ModifyIndexParamInner;
import com.tencent.tcvectordb.service.param.QueryCountParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class VectorDBClient {
    protected Stub stub;
    protected ReadConsistencyEnum readConsistency;

    public VectorDBClient(ConnectParam connectParam, ReadConsistencyEnum readConsistency) {
        this.stub = new HttpStub(connectParam);
        this.readConsistency = readConsistency;
    }

    protected VectorDBClient() {
    }

    public void close() {
        if (this.stub != null) {
            this.stub.close();
        }
    }

    public Database createDatabase(String databaseName) throws VectorDBException {
        Database db = this.database(databaseName, this.readConsistency);
        this.stub.createDatabase(db);
        return db;
    }

    public Database createDatabaseIfNotExists(String databaseName) throws VectorDBException {
        Database db = this.database(databaseName, this.readConsistency);
        List<String> databaseNames = this.stub.listDatabases();
        if (databaseNames.contains(databaseName)) {
            return new Database(this.stub, databaseName, this.readConsistency);
        }
        this.stub.createDatabase(db);
        return db;
    }

    @Deprecated
    public Boolean existsDatabase(String databaseName) throws VectorDBException {
        List<String> databaseNames = this.stub.listDatabases();
        if (databaseNames != null && databaseNames.contains(databaseName)) {
            return true;
        }
        return false;
    }

    public Boolean IsExistsDatabase(String databaseName) throws VectorDBException {
        List<String> databaseNames = this.stub.listDatabases();
        if (databaseNames != null && databaseNames.contains(databaseName)) {
            return true;
        }
        return false;
    }

    public Database dropDatabase(String databaseName) throws VectorDBException {
        Database db = this.database(databaseName, this.readConsistency);
        this.stub.dropDatabase(db);
        return db;
    }

    public AIDatabase createAIDatabase(String databaseName) throws VectorDBException {
        AIDatabase db = this.aiDatabase(databaseName);
        this.stub.createAIDatabase(db);
        return db;
    }

    public AffectRes dropAIDatabase(String databaseName) throws VectorDBException {
        AIDatabase db = this.aiDatabase(databaseName);
        return this.stub.dropAIDatabase(db);
    }

    public List<String> listDatabase() throws VectorDBException {
        return this.stub.listDatabases();
    }

    @Deprecated
    public Database database(String databaseName, ReadConsistencyEnum readConsistency) {
        return new Database(this.stub, databaseName, readConsistency);
    }

    public Database database(String databaseName) {
        return new Database(this.stub, databaseName, this.readConsistency);
    }

    public AIDatabase aiDatabase(String databaseName) {
        return new AIDatabase(this.stub, databaseName, this.readConsistency);
    }

    @Deprecated
    public Boolean existsCollection(String databaseName, String collection) throws VectorDBException {
        Collection collectionInfo = null;
        try {
            collectionInfo = this.stub.describeCollection(databaseName, collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collectionInfo != null;
    }

    public Boolean IsExistsCollection(String databaseName, String collection) throws VectorDBException {
        Collection collectionInfo = null;
        try {
            collectionInfo = this.stub.describeCollection(databaseName, collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collectionInfo != null;
    }

    public Collection createCollectionIfNotExists(String databaseName, CreateCollectionParam param) throws VectorDBException {
        Collection collections = null;
        try {
            collections = this.stub.describeCollection(databaseName, param.getCollection());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setDatabase(databaseName);
        param.setReadConsistency(this.readConsistency);
        if (collections == null) {
            this.stub.createCollection(param);
        }
        param.setStub(this.stub);
        return param;
    }

    public List<Collection> listCollections(String databaseName) throws VectorDBException {
        List<Collection> collections = this.stub.listCollections(databaseName);
        collections.forEach(c -> {
            c.setStub(this.stub);
            c.setReadConsistency(this.readConsistency);
        });
        return collections;
    }

    public AffectRes truncateCollections(String databaseName, String collectionName) {
        return this.stub.truncateCollection(databaseName, collectionName, DataBaseTypeEnum.BASE_DB);
    }

    public Collection describeCollection(String databaseName, String collectionName) throws VectorDBException {
        Collection collection = this.stub.describeCollection(databaseName, collectionName);
        collection.setStub(this.stub);
        collection.setReadConsistency(this.readConsistency);
        return collection;
    }

    public void dropCollection(String databaseName, String collectionName) throws VectorDBException {
        this.stub.dropCollection(databaseName, collectionName);
    }

    public AffectRes setAlias(String databaseName, String collectionName, String aliasName) {
        return this.stub.setAlias(databaseName, collectionName, aliasName);
    }

    public AffectRes deleteAlias(String databaseName, String aliasName) {
        return this.stub.deleteAlias(databaseName, aliasName);
    }

    public AffectRes upsert(String database, String collection, InsertParam param) throws VectorDBException {
        boolean ai = false;
        if (param.getDocuments().get(0) != null) {
            if (param.getDocuments().get(0) instanceof Document && ((Document)param.getDocuments().get(0)).getVector() instanceof String) {
                ai = true;
            }
            if (param.getDocuments().get(0) instanceof JSONObject && ((JSONObject)param.getDocuments().get(0)).get("vector") instanceof String) {
                ai = true;
            }
        }
        InsertParamInner insertParam = new InsertParamInner(database, collection, param);
        return this.stub.upsertDocument(insertParam, ai);
    }

    public List<Document> query(String database, String collection, QueryParam param) throws VectorDBException {
        return this.stub.queryDocument(new QueryParamInner(database, collection, param, this.readConsistency), false);
    }

    public List<List<Document>> search(String database, String collection, SearchByVectorParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE).getDocuments();
    }

    public List<List<Document>> searchById(String database, String collection, SearchByIdParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE).getDocuments();
    }

    public SearchRes searchByEmbeddingItems(String database, String collection, SearchByEmbeddingItemsParam param) throws VectorDBException {
        return this.stub.searchDocument(new SearchParamInner(database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE);
    }

    public AffectRes delete(String database, String collection, DeleteParam param) throws VectorDBException {
        return this.stub.deleteDocument(new DeleteParamInner(database, collection, param));
    }

    public AffectRes update(String database, String collection, UpdateParam param, Document document) throws VectorDBException {
        boolean ai = false;
        if (document.getVector() instanceof String) {
            ai = true;
        }
        return this.stub.updateDocument(new UpdateParamInner(database, collection, param, document), ai);
    }

    public AffectRes update(String database, String collection, UpdateParam param, JSONObject document) throws VectorDBException {
        boolean ai = false;
        if (document.get("vector") instanceof String) {
            ai = true;
        }
        return this.stub.updateDocument(new UpdateParamInner(database, collection, param, document), ai);
    }

    public HybridSearchRes hybridSearch(String database, String collection, HybridSearchParam param) throws VectorDBException {
        boolean ai = false;
        if (param.getAnn() != null && !param.getAnn().isEmpty() && param.getAnn().get(0).getData() != null && !param.getAnn().get(0).getData().isEmpty() && param.getAnn().get(0).getData().get(0) instanceof String) {
            ai = true;
        }
        return this.stub.hybridSearchDocument(new HybridSearchParamInner(database, collection, param, this.readConsistency), ai);
    }

    @Deprecated
    public BaseRes AddIndex(String database, String collection, AddIndexParam addIndexParam) throws VectorDBException {
        return this.stub.addIndex(new AddIndexParamInner(database, collection, addIndexParam));
    }

    public BaseRes rebuildIndex(String database, String collection, RebuildIndexParam rebuildIndexParam) {
        return this.stub.rebuildIndex(new RebuildIndexParamInner(database, collection, rebuildIndexParam));
    }

    public BaseRes addIndex(String database, String collection, AddIndexParam addIndexParam) throws VectorDBException {
        return this.stub.addIndex(new AddIndexParamInner(database, collection, addIndexParam));
    }

    public BaseRes dropIndex(String database, String collection, List<String> fieldNames) throws VectorDBException {
        return this.stub.dropIndex(new DropIndexParamInner(database, collection, fieldNames));
    }

    public BaseRes count(String database, String collection, CountQueryParam countQueryParam) throws VectorDBException {
        return this.stub.countDocument(new QueryCountParamInner(database, collection, countQueryParam, this.readConsistency), false);
    }

    public BaseRes modifyVectorIndex(String database, String collection, ModifyVectorIndexParam modifyVectorIndexParam) throws VectorDBException {
        return this.stub.modifyVectorIndex(new ModifyIndexParamInner(database, collection, modifyVectorIndexParam), false);
    }

    public BaseRes createUser(String username, String password) throws VectorDBException {
        return this.stub.createUser(new UserCreateParam(username, password));
    }

    public BaseRes grantToUser(UserGrantParam param) throws VectorDBException {
        return this.stub.grantToUser(param);
    }

    public BaseRes revokeFromUser(UserRevokeParam param) throws VectorDBException {
        return this.stub.revokeFromUser(param);
    }

    public UserDescribeRes describeUser(String user) throws VectorDBException {
        return this.stub.describeUser(new UserDescribeParam(user));
    }

    public UserListRes listUser() throws VectorDBException {
        return this.stub.listUser();
    }

    public BaseRes dropUser(String user) throws VectorDBException {
        return this.stub.dropUser(new UserDropParam(user));
    }

    public BaseRes changePassword(String user, String password) throws VectorDBException {
        return this.stub.changeUserPassword(UserChangePasswordParam.newBuilder().withUser(user).withPassword(password).build());
    }

    public void UploadFile(String database, String collection, UploadFileParam collectionLoadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        this.stub.collectionUpload(database, collection, collectionLoadAndSplitTextParam, metaDataMap);
    }

    public GetImageUrlRes GetImageUrl(String database, String collection, GetImageUrlParam param) {
        GetImageUrlParamInner paramInner = new GetImageUrlParamInner();
        paramInner.setDatabase(database);
        paramInner.setCollection(collection);
        paramInner.setFileName(param.getFileName());
        paramInner.setDocumentIds(param.getDocumentIds());
        return this.stub.GetImageUrl(paramInner);
    }
}

