/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.RPCVectorDBClient;
import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class CommonService {
    private CommonService() {
    }

    private static ConnectParam initConnectParam() {
        String vdbURL = "";
        String vdbKey = "";
        System.out.println("\tvdb_url: " + vdbURL);
        System.out.println("\tvdb_key: " + vdbKey);
        return ConnectParam.newBuilder().withUrl(vdbURL).withUsername("root").withKey(vdbKey).withTimeout(30).build();
    }

    public static VectorDBClient initClient() {
        return new RPCVectorDBClient(CommonService.initConnectParam(), ReadConsistencyEnum.EVENTUAL_CONSISTENCY);
    }

    public static void anySafe(Runnable run) {
        try {
            run.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<Double> generateRandomVector(int dim) {
        Random random = new Random();
        ArrayList<Double> vectors = new ArrayList<Double>();
        for (int i = 0; i < dim; ++i) {
            double randomDouble = 0.0 + random.nextDouble() * 1.0;
            vectors.add(randomDouble);
        }
        return vectors;
    }
}

