/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.TTLConfig;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.AddIndexParam;
import com.tencent.tcvectordb.model.param.dml.CountQueryParam;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.Filter;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.ModifyVectorIndexParam;
import com.tencent.tcvectordb.model.param.dml.OrderRule;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.enums.OrderEnum;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorDBExample {
    private static final String DBNAME = "java_sdk_book";
    private static final String COLL_NAME = "java_sdk_book_segments";
    private static final String COLL_NAME_ALIAS = "java_sdk_collection_alias";

    public static void main(String[] args) throws InterruptedException {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBExample.createDatabaseAndCollection(client);
        VectorDBExample.upsertData(client);
        VectorDBExample.queryData(client);
        VectorDBExample.addIndex(client);
        VectorDBExample.dropIndex(client);
        VectorDBExample.modifyVectorIndex(client);
        VectorDBExample.updateAndDelete(client);
        VectorDBExample.deleteAndDrop(client);
        VectorDBExample.testFilter();
    }

    private static void addIndex(VectorDBClient client) throws InterruptedException {
        BaseRes baseRes = client.addIndex(DBNAME, COLL_NAME, AddIndexParam.newBuilder().withBuildExistedData(true).withIndexes(Arrays.asList(new FilterIndex("owner", FieldType.Uint64, IndexType.FILTER))).build());
        System.out.println("--------add index-------");
        System.out.println("\t res: " + JsonUtils.toJsonString(baseRes));
        Thread.sleep(1000L);
        System.out.println("--------describe collection-------");
        Database db = client.database(DBNAME);
        Collection collection = db.describeCollection(COLL_NAME);
        System.out.println("\t collection describe: " + JsonUtils.toJsonString(collection));
        List<Document> documentList = Arrays.asList(Document.newBuilder().withId("0006").withVector(Arrays.asList(0.2123, 0.21, 0.214)).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 21)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("array_test", Arrays.asList("1", "2", "3"))).addDocField(new DocField("owner", 2)).build(), Document.newBuilder().withId("0007").withVector(Arrays.asList(0.2123, 0.22, 0.215)).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 22)).addDocField(new DocField("segment", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).addDocField(new DocField("array_test", Arrays.asList("4", "5", "6"))).addDocField(new DocField("owner", 1)).build());
        client.upsert(DBNAME, COLL_NAME, InsertParam.newBuilder().addAllDocument(documentList).build());
        Thread.sleep(3000L);
        List<Document> docs = client.query(DBNAME, COLL_NAME, ((QueryParam.Builder)QueryParam.newBuilder().withFilter("owner=1")).withLimit(10L).build());
        for (int i = 0; i < docs.size(); ++i) {
            System.out.println("res " + i + " " + JsonUtils.toJsonString(docs.get(i)));
        }
    }

    private static void dropIndex(VectorDBClient client) throws InterruptedException {
        System.out.println("--------describe collection, before drop index-------");
        Collection collection = client.describeCollection(DBNAME, COLL_NAME);
        System.out.println("\t collection describe: " + JsonUtils.toJsonString(collection));
        BaseRes baseRes = client.dropIndex(DBNAME, COLL_NAME, Arrays.asList("owner"));
        System.out.println("--------drop index-------");
        System.out.println("\t res: " + JsonUtils.toJsonString(baseRes));
        Thread.sleep(1000L);
        System.out.println("--------describe collection, after drop index-------");
        System.out.println("\t collection describe: " + JsonUtils.toJsonString(client.describeCollection(DBNAME, COLL_NAME)));
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabaseIfNotExists(DBNAME);
        Boolean isExisted = client.IsExistsDatabase(DBNAME);
        System.out.println("---------------------- listCollections ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBExample.initCreateCollectionParam(COLL_NAME);
        client.createCollectionIfNotExists(DBNAME, collectionParam);
        System.out.println("java_sdk_book_segments exists: " + db.IsExistsCollection(COLL_NAME));
        System.out.println("---------------------- listCollections ----------------------");
        List<Collection> cols = client.listCollections(DBNAME);
        for (Collection col : cols) {
            System.out.println("\tres: " + col.toString());
        }
        System.out.println("---------------------- setAlias ----------------------");
        AffectRes affectRes = db.setAlias(COLL_NAME, COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes.toString());
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes.toString());
        System.out.println("---------------------- deleteAlias ----------------------");
        AffectRes affectRes1 = db.deleteAlias(COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes1);
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes1 = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes1.toString());
    }

    private static void upsertData(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").withVector(Arrays.asList(0.2123, 0.21, 0.213)).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 21)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("array_test", Arrays.asList("1", "2", "3"))).addDocField(new DocField("owner", 2)).addDocField(new DocField("double_test", 3.3)).build(), Document.newBuilder().withId("0002").withVector(Arrays.asList(0.2123, 0.22, 0.213)).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 22)).addDocField(new DocField("segment", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).addDocField(new DocField("array_test", Arrays.asList("4", "5", "6"))).addDocField(new DocField("owner", 1)).addDocField(new DocField("double_test", 4.3)).build(), Document.newBuilder().withId("0003").withVector(Arrays.asList(0.2123, 0.23, 0.213)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 23)).addDocField(new DocField("segment", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).addDocField(new DocField("array_test", Arrays.asList("7", "8", "9"))).addDocField(new DocField("owner", 2)).build(), Document.newBuilder().withId("0004").withVector(Arrays.asList(0.2123, 0.24, 0.213)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 24)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("array_test", Arrays.asList("10", "11", "12"))).addDocField(new DocField("owner", 2)).addDocField(new DocField("double_test", 5.3)).addDocField(new DocField("expired_at", System.currentTimeMillis() / 1000L + 86400L)).build(), Document.newBuilder().withId("0005").withVector(Arrays.asList(0.2123, 0.25, 0.213)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 25)).addDocField(new DocField("segment", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002")).addDocField(new DocField("owner", 1)).addDocField(new DocField("expired_at", System.currentTimeMillis() / 1000L + 600L)).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().withDocuments(documentList).build();
        collection.upsert(insertParam);
        AffectRes affectRes = client.upsert(DBNAME, COLL_NAME, insertParam);
        System.out.println(JsonUtils.toJsonString(affectRes));
        Thread.sleep(5000L);
        BaseRes res = client.count(DBNAME, COLL_NAME, CountQueryParam.newBuilder().withFilter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"").build());
        System.out.println("count document: " + res.getCount());
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        List<String> documentIds = Arrays.asList("0001", "0002", "0003", "0004", "0005");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"").and(Filter.exclude("array_test", Arrays.asList("7")));
        List<String> outputFields = Arrays.asList("id", "bookName");
        QueryParam queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(Arrays.asList("0001", "0002", "0003", "0004", "0005"))).withLimit(5L).withOffset(0L).withRetrieveVector(false).withSort(OrderRule.newBuilder().withFieldName("page").withDirection(OrderEnum.DESC).build()).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- searchById ----------------------");
        SearchByIdParam searchByIdParam = ((SearchByIdParam.Builder)((SearchByIdParam.Builder)((SearchByIdParam.Builder)SearchByIdParam.newBuilder().withDocumentIds(documentIds).withParams(new HNSWSearchParams(100))).withLimit(2)).withFilter(filterParam)).build();
        List<List<Document>> siDocs = client.searchById(DBNAME, COLL_NAME, searchByIdParam);
        int i = 0;
        for (List<Document> docs : siDocs) {
            System.out.println("\tres: " + i++);
            for (Document document : docs) {
                System.out.println("\tres: " + document.toString());
            }
        }
        System.out.println("---------------------- search ----------------------");
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().addVector(Arrays.asList(0.2123, 0.23, 0.213)).withParams(new HNSWSearchParams(100))).withLimit(10)).withFilter(filterParam)).build();
        List<List<Document>> svDocs = client.search(DBNAME, COLL_NAME, searchByVectorParam);
        i = 0;
        for (List list : svDocs) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc : list) {
                System.out.println("\tres: " + doc.toString());
            }
        }
    }

    private static void updateAndDelete(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- update ----------------------");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"");
        List<String> documentIds = Arrays.asList("0001", "0003");
        UpdateParam updateParam = ((UpdateParam.Builder)((UpdateParam.Builder)UpdateParam.newBuilder().addAllDocumentId(documentIds)).withFilter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"")).build();
        Document updateDoc = Document.newBuilder().addDocField(new DocField("page", 100)).addDocField(new DocField("extend", "extendContent")).addDocField(new DocField("array_test", Arrays.asList("extendContent", "extendContent1"))).build();
        AffectRes affectRes = client.update(DBNAME, COLL_NAME, updateParam, updateDoc);
        System.out.println(affectRes.toString());
        System.out.println("---------------------- delete ----------------------");
        filterParam = new Filter("bookName=\"\u897f\u6e38\u8bb0\"");
        DeleteParam build = ((DeleteParam.Builder)((DeleteParam.Builder)DeleteParam.newBuilder().addAllDocumentId("0001", "0003")).withFilter("bookName=\"\u897f\u6e38\u8bb0\"")).withLimit(1).build();
        AffectRes deleteAffectRes = client.delete(DBNAME, COLL_NAME, build);
        System.out.println(deleteAffectRes.toString());
        System.out.println("---------------------- rebuildIndex ----------------------");
        RebuildIndexParam rebuildIndexParam = RebuildIndexParam.newBuilder().withDropBeforeRebuild(false).withThrottle(1).build();
        collection.rebuildIndex(rebuildIndexParam);
        Thread.sleep(5000L);
        System.out.println("----------------------  query ----------------------");
        documentIds = Arrays.asList("0001", "0002", "0003", "0004", "0005");
        QueryParam queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(documentIds)).withRetrieveVector(false).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- truncate collection ----------------------");
        AffectRes affectRes1 = database.truncateCollections(COLL_NAME);
        System.out.println("\tres: " + JsonUtils.toJsonString(affectRes1));
        Thread.sleep(5000L);
    }

    private static void deleteAndDrop(VectorDBClient client) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- truncate collection ----------------------");
        database.dropCollection(COLL_NAME);
        System.out.println("---------------------- truncate collection ----------------------");
        client.dropDatabase(DBNAME);
    }

    private static void clear(VectorDBClient client) {
        client.dropDatabase(DBNAME);
    }

    private static CreateCollectionParam initCreateCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(1).withDescription("test collection0").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", (Integer)3, IndexType.HNSW, MetricType.COSINE, new HNSWParams(16, 200))).addField(new FilterIndex("bookName", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("array_test", FieldType.Array, IndexType.FILTER)).addField(new FilterIndex("expired_at", FieldType.Uint64, IndexType.FILTER)).addField(new FilterIndex("page", FieldType.Uint64, IndexType.FILTER)).withTtlConfig(TTLConfig.newBuilder().WithEnable(true).WithTimeField("expired_at").build()).build();
    }

    public static void testFilter() {
        System.out.println("---------------------- testFilter ----------------------");
        System.out.println("\tres: " + new Filter("author=\"jerry\"").and("a=1").or("r=\"or\"").orNot("rn=2").andNot("an=\"andNot\"").and(Filter.include("key", Arrays.asList("1", "2", "3"))).getCond());
        System.out.println("\tres: " + Filter.in("key", Arrays.asList("v1", "v2", "v3")));
        System.out.println("\tres: " + Filter.in("key", Arrays.asList(1, 2, 3)));
        System.out.println(Document.newBuilder().withId("0003").withVector(Arrays.asList(0.2123, 0.23, 0.213)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 23)).addDocField(new DocField("segment", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).addDocField(new DocField("array_test", Arrays.asList("7", "8", "9"))).build().toString());
    }

    private static void modifyVectorIndex(VectorDBClient client) throws InterruptedException {
        System.out.println("--------modify vector index-------");
        Database db = client.database(DBNAME);
        Collection collection = db.describeCollection(COLL_NAME);
        System.out.println("before");
        System.out.println(JsonUtils.toJsonString(collection));
        BaseRes baseRes = client.modifyVectorIndex(DBNAME, COLL_NAME, ModifyVectorIndexParam.newBuilder().withVectorIndex(new VectorIndex(MetricType.IP, new HNSWParams(8, 100))).withRebuildRules(RebuildIndexParam.newBuilder().withDropBeforeRebuild(true).withThrottle(1).build()).build());
        System.out.println("modify res: " + JsonUtils.toJsonString(baseRes));
        Collection collectionAfter = db.describeCollection(COLL_NAME);
        System.out.println("after");
        System.out.println(JsonUtils.toJsonString(collectionAfter));
    }
}

