/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.AIDatabase;
import com.tencent.tcvectordb.model.CollectionView;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collectionView.CreateCollectionViewParam;
import com.tencent.tcvectordb.model.param.collectionView.EmbeddingParams;
import com.tencent.tcvectordb.model.param.collectionView.FileType;
import com.tencent.tcvectordb.model.param.collectionView.LanguageType;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.dml.CollectionViewConditionParam;
import com.tencent.tcvectordb.model.param.dml.CollectionViewQueryParam;
import com.tencent.tcvectordb.model.param.dml.Filter;
import com.tencent.tcvectordb.model.param.dml.RerankOption;
import com.tencent.tcvectordb.model.param.dml.SearchByContentsParam;
import com.tencent.tcvectordb.model.param.dml.SearchOption;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VectorDBExampleWithAI_doc {
    private static final String DBNAME = "db_test-ai";
    private static final String COLL_NAME = "coll-ai-files";
    private static final String COLL_NAME_ALIAS = "alias-coll-ai-files";

    public static void main(String[] args) throws Exception {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropAIDatabase(DBNAME));
        VectorDBExampleWithAI_doc.createAiDatabaseAndCollectionView(client);
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>();
        metaDataMap.put("author", "Tencent");
        metaDataMap.put("tags", Arrays.asList("Embedding", "\u5411\u91cf", "AI"));
        VectorDBExampleWithAI_doc.loadAndSplitText(client, System.getProperty("file_path"), "\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md", metaDataMap);
        Thread.sleep(10000L);
        VectorDBExampleWithAI_doc.queryData(client);
        VectorDBExampleWithAI_doc.GetFile(client, "\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md");
        VectorDBExampleWithAI_doc.updateAndDelete(client);
        VectorDBExampleWithAI_doc.deleteAndDrop(client);
    }

    private static void createAiDatabaseAndCollectionView(VectorDBClient client) throws InterruptedException {
        System.out.println("---------------------- create AI Database ----------------------");
        AIDatabase db = client.createAIDatabase(DBNAME);
        System.out.println("---------------------- listDatabase ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollectionView ----------------------");
        CreateCollectionViewParam collectionViewParam = VectorDBExampleWithAI_doc.initCreateCollectionViewParam(COLL_NAME);
        db.createCollectionView(collectionViewParam);
        System.out.println("---------------------- listCollectionView ----------------------");
        List<CollectionView> cols = db.listCollectionView();
        for (CollectionView col : cols) {
            System.out.println("\tres: " + col.toString());
        }
        System.out.println("---------------------- setAIAlias ----------------------");
        AffectRes affectRes = db.setAIAlias(COLL_NAME, COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes.toString());
        Thread.sleep(5000L);
        System.out.println("---------------------- describeCollectionView ----------------------");
        CollectionView descCollRes = db.describeCollectionView(COLL_NAME);
        System.out.println("\tres: " + descCollRes.toString());
        System.out.println("---------------------- deleteAIAlias ----------------------");
        AffectRes affectRes1 = db.deleteAIAlias(COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes1);
        System.out.println("---------------------- describeCollectionView ----------------------");
        CollectionView descCollRes1 = db.describeCollectionView(COLL_NAME);
        System.out.println("\tres: " + descCollRes1.toString());
    }

    private static void loadAndSplitText(VectorDBClient client, String filePath, String documentSetName, Map<String, Object> metaDataMap) throws Exception {
        AIDatabase database = client.aiDatabase(DBNAME);
        CollectionView collection = database.describeCollectionView(COLL_NAME);
        LoadAndSplitTextParam param = LoadAndSplitTextParam.newBuilder().withLocalFilePath(filePath).withDocumentSetName(documentSetName).withSplitterProcess(SplitterPreprocessParams.newBuilder().withAppendKeywordsToChunkEnum(true).Build()).Build();
        collection.loadAndSplitText(param, metaDataMap);
    }

    private static void loadAndSplitTextUseInputStream(VectorDBClient client, InputStream inputStream, Long inputStreamSize, String documentSetName, Map<String, Object> metaDataMap) throws Exception {
        AIDatabase database = client.aiDatabase(DBNAME);
        CollectionView collection = database.describeCollectionView(COLL_NAME);
        LoadAndSplitTextParam param = LoadAndSplitTextParam.newBuilder().withFileInputStream(inputStream).withInputStreamDataSize(inputStreamSize).withDocumentSetName(documentSetName).withFileType(FileType.MD).withSplitterProcess(SplitterPreprocessParams.newBuilder().withAppendKeywordsToChunkEnum(true).Build()).Build();
        collection.loadAndSplitText(param, metaDataMap);
    }

    private static void GetFile(VectorDBClient client, String fileName) {
        AIDatabase database = client.aiDatabase(DBNAME);
        CollectionView collection = database.describeCollectionView(COLL_NAME);
        System.out.println(collection.getFile(fileName, "").toString());
    }

    private static void queryData(VectorDBClient client) {
        AIDatabase database = client.aiDatabase(DBNAME);
        CollectionView collectionView = database.describeCollectionView(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        CollectionViewQueryParam queryParam = ((CollectionViewQueryParam.Builder)CollectionViewQueryParam.newBuilder().withLimit(2).withDocumentSetNames((List)Arrays.asList("\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md"))).build();
        List<DocumentSet> qdos = collectionView.query(queryParam);
        for (DocumentSet doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- get chunks ----------------------");
        System.out.println("get chunks res :");
        System.out.println(JsonUtils.toJsonString(collectionView.getChunks(null, "\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md", 60, 0)));
        System.out.println("---------------------- search ----------------------");
        SearchOption option = SearchOption.newBuilder().withChunkExpand(Arrays.asList(1, 1)).withRerank(new RerankOption(true, 3.0)).build();
        SearchByContentsParam searchByContentsParam = SearchByContentsParam.newBuilder().withContent("\u4ec0\u4e48\u662f\u5411\u91cf").withSearchContentOption(option).withFilter(new Filter(Filter.in("author", Arrays.asList("Tencent", "tencent"))).and(Filter.include("tags", Arrays.asList("AI", "Embedding"))).getCond()).withDocumentSetName(Arrays.asList("\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md")).build();
        List<SearchContentInfo> searchRes = collectionView.search(searchByContentsParam);
        int i = 0;
        for (SearchContentInfo doc : searchRes) {
            System.out.println("\tres" + i++ + ": " + doc.toString());
        }
    }

    private static void updateAndDelete(VectorDBClient client) throws InterruptedException {
        AIDatabase database = client.aiDatabase(DBNAME);
        CollectionView collectionView = database.describeCollectionView(COLL_NAME);
        System.out.println("---------------------- update ----------------------");
        Filter filterParam = new Filter("author=\"Tencent\"");
        CollectionViewConditionParam updateParam = CollectionViewConditionParam.newBuilder().withDocumentSetNames(Arrays.asList("\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md")).withFilter(filterParam).build();
        HashMap<String, Object> updateFieldValues = new HashMap<String, Object>();
        updateFieldValues.put("page", 100);
        updateFieldValues.put("author", "tencent");
        updateFieldValues.put("array_test", Arrays.asList("1", "2", "5"));
        collectionView.update(updateParam, updateFieldValues);
        System.out.println(collectionView.query(10).get(0).toString());
        System.out.println("---------------------- delete ----------------------");
        Filter filterParam1 = new Filter("author=\"tencent\"");
        CollectionViewConditionParam build = CollectionViewConditionParam.newBuilder().withDocumentSetNames(Arrays.asList("\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93.md")).withFilter(filterParam1).build();
        AffectRes affectRes = collectionView.deleteDocumentSets(build);
        System.out.println("\tres: " + affectRes.toString());
        System.out.println(collectionView.query().size());
        System.out.println("---------------------- truncate ----------------------");
        database.truncateCollectionView(COLL_NAME);
    }

    private static void deleteAndDrop(VectorDBClient client) {
        AIDatabase database = client.aiDatabase(DBNAME);
        System.out.println("---------------------- dropCollection ----------------------");
        database.dropCollectionView(COLL_NAME);
        System.out.println("---------------------- dropDatabase ----------------------");
        client.dropAIDatabase(DBNAME);
    }

    private static void clear(VectorDBClient client) {
        client.dropAIDatabase(DBNAME);
    }

    private static CreateCollectionViewParam initCreateCollectionViewParam(String collName) {
        return CreateCollectionViewParam.newBuilder().withName(collName).withDescription("test create ai collection").withEmbedding(EmbeddingParams.newBuilder().withEnableWordEmbedding(true).withLanguage(LanguageType.ZH).Build()).withAverageFileSize(204800).withExpectedFileNum(10240).withReplicaNum(0).withShardNum(2).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("tags", FieldType.Array, IndexType.FILTER)).withSplitterPreprocess(SplitterPreprocessParams.newBuilder().withAppendKeywordsToChunkEnum(true).withAppendTitleToChunkEnum(false).Build()).build();
    }
}

