/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.UploadFileParam;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.collectionView.ParsingProcessParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.dml.GetImageUrlParam;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.OrderRule;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.entity.GetImageUrlRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import com.tencent.tcvectordb.model.param.enums.OrderEnum;
import com.tencent.tcvectordb.model.param.enums.ParsingTypeEnum;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VectorDBExampleWithCollectionUploadFile {
    private static final String DBNAME = "db-test-java-sdk";
    private static final String COLL_NAME = "coll-file_parse_java-sdk";

    public static void main(String[] args) throws Exception {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBExampleWithCollectionUploadFile.createDatabaseAndCollection(client);
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>();
        metaDataMap.put("author", "Tencent");
        metaDataMap.put("tags", Arrays.asList("Embedding", "\u5411\u91cf", "AI"));
        VectorDBExampleWithCollectionUploadFile.UploadFile(client, System.getProperty("file_path"), "tcvdb.pdf", metaDataMap);
        Thread.sleep(30000L);
        VectorDBExampleWithCollectionUploadFile.queryData(client);
        client.dropDatabase(DBNAME);
    }

    private static void createDatabaseAndCollection(VectorDBClient client) throws InterruptedException {
        System.out.println("---------------------- create Database ----------------------");
        Database db = client.createDatabase(DBNAME);
        System.out.println("---------------------- listDatabase ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBExampleWithCollectionUploadFile.initCreateCollectionParam(COLL_NAME);
        client.createCollectionIfNotExists(DBNAME, collectionParam);
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes = client.describeCollection(DBNAME, COLL_NAME);
        System.out.println("\tres: " + descCollRes.toString());
    }

    private static void UploadFile(VectorDBClient client, String filePath, String fileName, Map<String, Object> metaDataMap) throws Exception {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("filename", "file_name");
        columnMap.put("text", "text");
        columnMap.put("imageList", "image_list");
        columnMap.put("chunkNum", "chunk_num");
        columnMap.put("sectionNum", "section_num");
        UploadFileParam param = UploadFileParam.newBuilder().withLocalFilePath(filePath).withSplitterProcess(SplitterPreprocessParams.newBuilder().withAppendKeywordsToChunkEnum(true).Build()).withParsingProcess(ParsingProcessParam.newBuilder().withParsingType(ParsingTypeEnum.AlgorithmParsing).build()).withFileName(fileName).withFieldMappings(columnMap).withEmbeddingModel(EmbeddingModelEnum.BGE_BASE_ZH.getModelName()).Build();
        client.UploadFile(DBNAME, COLL_NAME, param, metaDataMap);
    }

    private static void UploadFileUseInputStream(VectorDBClient client, InputStream inputStream, Long inputStreamSize, String fileName, Map<String, Object> metaDataMap) throws Exception {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("filename", "file_name");
        columnMap.put("text", "text");
        columnMap.put("imageList", "image_list");
        columnMap.put("chunkNum", "chunk_num");
        columnMap.put("sectionNum", "section_num");
        UploadFileParam param = UploadFileParam.newBuilder().withFileInputStream(inputStream).withInputStreamDataSize(inputStreamSize).withFileName(fileName).withSplitterProcess(SplitterPreprocessParams.newBuilder().withAppendKeywordsToChunkEnum(true).Build()).withParsingProcess(ParsingProcessParam.newBuilder().withParsingType(ParsingTypeEnum.AlgorithmParsing).build()).withFieldMappings(columnMap).withEmbeddingModel(EmbeddingModelEnum.BGE_BASE_ZH.getModelName()).Build();
        client.UploadFile(DBNAME, COLL_NAME, param, metaDataMap);
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        QueryParam queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withFilter("file_name=\"tcvdb.pdf\"")).withLimit(20L).withOffset(0L).withRetrieveVector(false).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc2 : qdos) {
            System.out.println("\tres: " + doc2.toString());
        }
        VectorDBExampleWithCollectionUploadFile.queryChunkBySectionNumAndChunkNum(client);
        System.out.println("---------------------- get image url ----------------------");
        GetImageUrlRes getImageUrlRes = client.GetImageUrl(DBNAME, COLL_NAME, GetImageUrlParam.newBuilder().setFileName("tcvdb.pdf").setDocumentIds(qdos.stream().map(doc -> doc.getId()).collect(Collectors.toList())).build());
        System.out.println("get image url res:");
        System.out.println(JsonUtils.toJsonString(getImageUrlRes.getImages()));
        System.out.println("---------------------- search ----------------------");
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().addVector(CommonService.generateRandomVector(768)).withParams(new HNSWSearchParams(100))).withLimit(10)).withFilter("file_name=\"tcvdb.pdf\"")).build();
        List<List<Document>> svDocs = client.search(DBNAME, COLL_NAME, searchByVectorParam);
        int i = 0;
        for (List<Document> docs : svDocs) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc3 : docs) {
                System.out.println("\tres: " + doc3.toString());
            }
        }
    }

    private static void queryChunkBySectionNumAndChunkNum(VectorDBClient client) {
        System.out.println("---------------------- search by text----------------------");
        SearchByEmbeddingItemsParam searchByEmbeddingItemsParam = ((SearchByEmbeddingItemsParam.Builder)((SearchByEmbeddingItemsParam.Builder)((SearchByEmbeddingItemsParam.Builder)SearchByEmbeddingItemsParam.newBuilder().withEmbeddingItems(Arrays.asList("\u5546\u6807\u58f0\u660e")).withParams(new HNSWSearchParams(100))).withLimit(10)).withFilter("file_name=\"tcvdb.pdf\"")).build();
        SearchRes searchRes = client.searchByEmbeddingItems(DBNAME, COLL_NAME, searchByEmbeddingItemsParam);
        int i = 0;
        for (List<Document> docsTemp : searchRes.getDocuments()) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc : docsTemp) {
                System.out.println("\tdocsTemp: " + doc.toString());
            }
        }
        if (searchRes.getDocuments().size() == 0 || searchRes.getDocuments().get(0).size() == 0) {
            return;
        }
        System.out.println("---------------------- get chunk text by chunk_num ----------------------");
        Long chunkNum = (Long)searchRes.getDocuments().get(0).get(0).getObject("chunk_num");
        Long sectionNum = (Long)searchRes.getDocuments().get(0).get(0).getObject("section_num");
        if (chunkNum == null || sectionNum == null) {
            return;
        }
        Long startChunkNum = chunkNum - 2L;
        if (startChunkNum < 0L) {
            startChunkNum = 0L;
        }
        QueryParam queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withFilter("file_name=\"tcvdb.pdf\"  and chunk_num >= " + startChunkNum + " and chunk_num <=" + (chunkNum + 2L))).withLimit(20L).withOffset(0L).withRetrieveVector(false).withSort(OrderRule.newBuilder().withFieldName("chunk_num").withDirection(OrderEnum.ASC).build()).build();
        List<Document> docs = client.query(DBNAME, COLL_NAME, queryParam);
        for (Document doc : docs) {
            System.out.println("\tres: " + doc.toString());
        }
        queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withFilter("file_name=\"tcvdb.pdf\"  and chunk_num >= " + startChunkNum + " and chunk_num <=" + (chunkNum + 2L) + " and section_num=" + sectionNum)).withLimit(20L).withOffset(0L).withRetrieveVector(false).withSort(OrderRule.newBuilder().withFieldName("chunk_num").withDirection(OrderEnum.ASC).build()).build();
        docs = client.query(DBNAME, COLL_NAME, queryParam);
        for (Document doc : docs) {
            System.out.println("\tres: " + doc.toString());
        }
    }

    private static CreateCollectionParam initCreateCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(0).withDescription("test collection0").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", (Integer)768, IndexType.HNSW, MetricType.COSINE, new HNSWParams(16, 200))).addField(new FilterIndex("file_name", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("text", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("image_list", FieldType.Array, IndexType.FILTER)).addField(new FilterIndex("chunk_num", FieldType.Uint64, IndexType.FILTER)).addField(new FilterIndex("section_num", FieldType.Uint64, IndexType.FILTER)).withEmbedding(Embedding.newBuilder().withModelName(EmbeddingModelEnum.BGE_BASE_ZH.getModelName()).withField("text").withVectorField("vector").build()).build();
    }
}

