/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.Filter;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorDBExampleWithEmbedding {
    private static final String DBNAME = "book";
    private static final String COLL_NAME = "book_segments_2";
    private static final String COLL_NAME_ALIAS = "collection_alias_2";

    public static void main(String[] args) throws Exception {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBExampleWithEmbedding.createDatabaseAndCollection(client);
        VectorDBExampleWithEmbedding.upsertData(client);
        VectorDBExampleWithEmbedding.queryData(client);
        VectorDBExampleWithEmbedding.updateAndDelete(client);
        VectorDBExampleWithEmbedding.deleteAndDrop(client);
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabase(DBNAME);
        System.out.println("---------------------- listDatabase ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBExampleWithEmbedding.initCreateEmbeddingCollectionParam(COLL_NAME);
        db.createCollection(collectionParam);
        System.out.println("---------------------- listCollections ----------------------");
        List<Collection> cols = db.listCollections();
        for (Collection col : cols) {
            System.out.println("\tres: " + col.toString());
        }
        System.out.println("---------------------- setAlias ----------------------");
        AffectRes affectRes = db.setAlias(COLL_NAME, COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes.toString());
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes.toString());
        System.out.println("---------------------- deleteAlias ----------------------");
        AffectRes affectRes1 = db.deleteAlias(COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes1);
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes1 = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes1.toString());
    }

    private static void upsertData(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 21)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("text", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).build(), Document.newBuilder().withId("0002").addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).addDocField(new DocField("page", 22)).addDocField(new DocField("segment", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).addDocField(new DocField("text", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).build(), Document.newBuilder().withId("0003").addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 23)).addDocField(new DocField("segment", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).addDocField(new DocField("text", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).build(), Document.newBuilder().withId("0004").addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 24)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("text", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).build(), Document.newBuilder().withId("0005").addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 25)).addDocField(new DocField("segment", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002")).addDocField(new DocField("text", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002")).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().addAllDocument(documentList).withBuildIndex(true).build();
        collection.upsert(insertParam);
        Thread.sleep(5000L);
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        List<String> documentIds = Arrays.asList("0001", "0002", "0003", "0004", "0005");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"");
        List<String> outputFields = Arrays.asList("id", "bookName");
        QueryParam queryParam = ((QueryParam.Builder)((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(documentIds)).withFilter(filterParam)).withLimit(2L).withOffset(1L).withOutputFields(outputFields).withRetrieveVector(false).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- searchById ----------------------");
        SearchByIdParam searchByIdParam = ((SearchByIdParam.Builder)((SearchByIdParam.Builder)((SearchByIdParam.Builder)SearchByIdParam.newBuilder().withDocumentIds(documentIds).withParams(new HNSWSearchParams(100))).withLimit(2)).withFilter(filterParam)).build();
        List<List<Document>> siDocs = collection.searchById(searchByIdParam);
        int i = 0;
        for (List<Document> docs : siDocs) {
            System.out.println("\tres: " + i++);
            for (Document doc : docs) {
                System.out.println("\tres: " + doc.toString());
            }
        }
        System.out.println("---------------------- search ----------------------");
        queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(documentIds)).withLimit(2L).withOffset(1L).withOutputFields(outputFields).withRetrieveVector(true).build();
        List<Document> allRes = collection.query(queryParam);
        ArrayList<List> vectors = new ArrayList<List>();
        for (Document document : allRes) {
            List vector = (List)document.getVector();
            vectors.add(vector);
        }
        ArrayList<List> test = vectors;
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().withVectors(vectors).withParams(new HNSWSearchParams(100))).withLimit(2)).withFilter(filterParam)).build();
        List<List<Document>> svDocs = collection.search(searchByVectorParam);
        i = 0;
        for (List<Document> docs : svDocs) {
            System.out.println("\tres: " + i++);
            for (Document document : docs) {
                System.out.println("\tres: " + document.toString());
            }
        }
        System.out.println("---------------------- searchByEmbeddingItems ----------------------");
        SearchByEmbeddingItemsParam searchByEmbeddingItemsParam = ((SearchByEmbeddingItemsParam.Builder)((SearchByEmbeddingItemsParam.Builder)SearchByEmbeddingItemsParam.newBuilder().withEmbeddingItems(Arrays.asList("\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f")).withParams(new HNSWSearchParams(100))).withLimit(5)).build();
        SearchRes searchRes = collection.searchByEmbeddingItems(searchByEmbeddingItemsParam);
        i = 0;
        for (List list : searchRes.getDocuments()) {
            System.out.println("\tres: " + i++);
            for (Document doc : list) {
                System.out.println("\tres: " + doc.toString());
            }
        }
    }

    private static void updateAndDelete(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- update ----------------------");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"");
        List<String> documentIds = Arrays.asList("0001", "0003");
        UpdateParam updateParam = ((UpdateParam.Builder)((UpdateParam.Builder)UpdateParam.newBuilder().addAllDocumentId(documentIds)).withFilter(filterParam)).build();
        Document updateDoc = Document.newBuilder().addDocField(new DocField("page", 100)).addDocField(new DocField("extend", "extendContent")).build();
        collection.update(updateParam, updateDoc);
        System.out.println("---------------------- delete ----------------------");
        filterParam = new Filter("bookName=\"\u897f\u6e38\u8bb0\"");
        DeleteParam build = ((DeleteParam.Builder)((DeleteParam.Builder)DeleteParam.newBuilder().addAllDocumentId(documentIds)).withFilter(filterParam)).build();
        collection.delete(build);
        Thread.sleep(5000L);
        System.out.println("---------------------- rebuild index ----------------------");
        RebuildIndexParam rebuildIndexParam = RebuildIndexParam.newBuilder().withDropBeforeRebuild(false).withThrottle(1).build();
        collection.rebuildIndex(rebuildIndexParam);
        Thread.sleep(5000L);
        System.out.println("---------------------- truncate collection ----------------------");
        AffectRes affectRes = database.truncateCollections(COLL_NAME);
        System.out.println("\tres: " + affectRes.toString());
        Thread.sleep(5000L);
    }

    private static void deleteAndDrop(VectorDBClient client) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- dropCollection ----------------------");
        database.dropCollection(COLL_NAME);
        System.out.println("---------------------- dropDatabase ----------------------");
        client.dropDatabase(DBNAME);
    }

    private static void clear(VectorDBClient client) {
        client.dropDatabase(DBNAME);
    }

    private static CreateCollectionParam initCreateEmbeddingCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(1).withDescription("test embedding collection0").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", (Integer)EmbeddingModelEnum.BGE_BASE_ZH.getDimension(), IndexType.HNSW, MetricType.COSINE, new HNSWParams(16, 200))).addField(new FilterIndex("bookName", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).withEmbedding(Embedding.newBuilder().withModelName("bge-base-zh").withField("text").withVectorField("vector").build()).build();
    }
}

