/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvdbtext.encoder.SparseVectorBm25Encoder;
import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.SparseVectorIndex;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.AnnOption;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.Filter;
import com.tencent.tcvectordb.model.param.dml.HybridSearchParam;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.MatchOption;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.dml.WeightRerankParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class VectorDBExampleWithSparseVector {
    private static final String DBNAME = "book_5";
    private static final String COLL_NAME = "book_segments_sparse_4";
    private static final String COLL_NAME_ALIAS = "collection_alias_sparse_4";

    public static void main(String[] args) throws InterruptedException {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBExampleWithSparseVector.createDatabaseAndCollection(client);
        VectorDBExampleWithSparseVector.upsertData(client);
        VectorDBExampleWithSparseVector.queryData(client);
        VectorDBExampleWithSparseVector.updateAndDelete(client);
        VectorDBExampleWithSparseVector.deleteAndDrop(client);
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabase(DBNAME);
        System.out.println("---------------------- listCollections ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBExampleWithSparseVector.initCreateCollectionParam(COLL_NAME);
        db.createCollection(collectionParam);
        System.out.println("---------------------- listCollections ----------------------");
        List<Collection> cols = db.listCollections();
        for (Collection col : cols) {
            System.out.println("\tres: " + col.toString());
        }
        System.out.println("---------------------- setAlias ----------------------");
        AffectRes affectRes = db.setAlias(COLL_NAME, COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes.toString());
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes.toString());
        System.out.println("---------------------- deleteAlias ----------------------");
        AffectRes affectRes1 = db.deleteAlias(COLL_NAME_ALIAS);
        System.out.println("\tres: " + affectRes1);
        System.out.println("---------------------- describeCollection ----------------------");
        Collection descCollRes1 = db.describeCollection(COLL_NAME);
        System.out.println("\tres: " + descCollRes1.toString());
    }

    private static List<Double> generateRandomVector(int dim) {
        Random random = new Random();
        ArrayList<Double> vectors = new ArrayList<Double>();
        for (int i = 0; i < dim; ++i) {
            double randomDouble = 0.0 + random.nextDouble() * 1.0;
            vectors.add(randomDouble);
        }
        return vectors;
    }

    private static void upsertData(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        SparseVectorBm25Encoder encoder = SparseVectorBm25Encoder.getBm25Encoder((String)"zh");
        List<String> texts = Arrays.asList("\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002\u201d\u5e03\u4ece\u5176\u8a00\uff0c\u7adf\u6295\u5f90\u5dde\u6765\u3002\u6709\u4eba\u62a5\u77e5\u7384\u5fb7\u3002", "\u7384\u5fb7\u66f0\uff1a\u201c\u5e03\u4e43\u5f53\u4eca\u82f1\u52c7\u4e4b\u58eb\uff0c\u53ef\u51fa\u8fce\u4e4b\u3002\u201d\u7cdc\u7afa\u66f0\uff1a\u201c\u5415\u5e03\u4e43\u864e\u72fc\u4e4b\u5f92\uff0c\u4e0d\u53ef\u6536\u7559\uff1b\u6536\u5219\u4f24\u4eba\u77e3\u3002");
        List sparseVectors = encoder.encodeTexts(texts);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").withVector(VectorDBExampleWithSparseVector.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(0)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 21)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("text", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).build(), Document.newBuilder().withId("0002").withVector(VectorDBExampleWithSparseVector.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(1)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 22)).addDocField(new DocField("segment", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).addDocField(new DocField("text", "\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1\u3002\u4e9b\u4e9b\u72c2\u5984\u5929\u52a0\u8c34\uff0c\u773c\u524d\u4e0d\u9047\u5f85\u65f6\u4e34\u3002")).build(), Document.newBuilder().withId("0003").withVector(VectorDBExampleWithSparseVector.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(2)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 23)).addDocField(new DocField("segment", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).addDocField(new DocField("text", "\u7ec6\u4f5c\u63a2\u77e5\u8fd9\u4e2a\u6d88\u606f\uff0c\u98de\u62a5\u5415\u5e03\u3002")).build(), Document.newBuilder().withId("0004").withVector(VectorDBExampleWithSparseVector.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(3)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 24)).addDocField(new DocField("segment", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).addDocField(new DocField("text", "\u5bcc\u8d35\u529f\u540d\uff0c\u524d\u7f18\u5206\u5b9a\uff0c\u4e3a\u4eba\u5207\u83ab\u6b3a\u5fc3\u3002")).build(), Document.newBuilder().withId("0005").withVector(VectorDBExampleWithSparseVector.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(4)).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).addDocField(new DocField("page", 25)).addDocField(new DocField("segment", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002")).addDocField(new DocField("text", "\u5e03\u5927\u60ca\uff0c\u4e0e\u9648\u5bab\u5546\u8bae\u3002\u5bab\u66f0\uff1a\u201c\u95fb\u5218\u7384\u5fb7\u65b0\u9886\u5f90\u5dde\uff0c\u53ef\u5f80\u6295\u4e4b\u3002")).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().addAllDocument(documentList).withBuildIndex(true).build();
        collection.upsert(insertParam);
        Thread.sleep(3000L);
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        List<String> documentIds = Arrays.asList("0001", "0002", "0003", "0004", "0005");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"");
        List<String> outputFields = Arrays.asList("id", "bookName", "segment");
        QueryParam queryParam = ((QueryParam.Builder)((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(documentIds)).withFilter(filterParam)).withLimit(2L).withOffset(1L).withOutputFields(outputFields).withRetrieveVector(false).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- hybridSearch ----------------------");
        SparseVectorBm25Encoder encoder = SparseVectorBm25Encoder.getBm25Encoder((String)"zh");
        HybridSearchParam hybridSearchParam = HybridSearchParam.newBuilder().withAnn(AnnOption.newBuilder().withFieldName("vector").withData(VectorDBExampleWithSparseVector.generateRandomVector(768)).build()).withMatch(MatchOption.newBuilder().withFieldName("sparse_vector").withData(encoder.encodeQueries(Arrays.asList("\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1"))).build()).withRerank(new WeightRerankParam(Arrays.asList("vector", "sparse_vector"), Arrays.asList(1, 1))).withLimit(10).withFilter(filterParam).withRetrieveVector(true).withOutputFields(Arrays.asList("segment")).build();
        List<Document> siDocs = client.hybridSearch(DBNAME, COLL_NAME, hybridSearchParam).getDocuments();
        int i = 0;
        for (Document docs : siDocs) {
            System.out.println("\tres: " + i++ + ((Object)docs).toString());
        }
    }

    private static void updateAndDelete(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- update ----------------------");
        Filter filterParam = new Filter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"");
        List<String> documentIds = Arrays.asList("0001", "0003");
        SparseVectorBm25Encoder encoder = SparseVectorBm25Encoder.getBm25Encoder((String)"zh");
        UpdateParam updateParam = ((UpdateParam.Builder)((UpdateParam.Builder)UpdateParam.newBuilder().addAllDocumentId(documentIds)).withFilter(filterParam)).build();
        Document updateDoc = Document.newBuilder().addDocField(new DocField("page", 100)).addDocField(new DocField("extend", "extendContent")).withSparseVector((List)encoder.encodeQueries(Arrays.asList("\u6b63\u5927\u5149\u660e\uff0c\u5fe0\u826f\u5584\u679c\u5f25\u6df1")).get(0)).build();
        collection.update(updateParam, updateDoc);
        System.out.println("---------------------- delete ----------------------");
        filterParam = new Filter("bookName=\"\u897f\u6e38\u8bb0\"");
        DeleteParam build = ((DeleteParam.Builder)((DeleteParam.Builder)DeleteParam.newBuilder().addAllDocumentId(documentIds)).withFilter(filterParam)).build();
        collection.delete(build);
        Thread.sleep(5000L);
        System.out.println("---------------------- rebuild index ----------------------");
        RebuildIndexParam rebuildIndexParam = RebuildIndexParam.newBuilder().withDropBeforeRebuild(false).withThrottle(1).build();
        collection.rebuildIndex(rebuildIndexParam);
        Thread.sleep(5000L);
        System.out.println("---------------------- truncate collection ----------------------");
        AffectRes affectRes = database.truncateCollections(COLL_NAME);
        System.out.println("\tres: " + affectRes.toString());
        Thread.sleep(5000L);
    }

    private static void deleteAndDrop(VectorDBClient client) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- dropCollection ----------------------");
        database.dropCollection(COLL_NAME);
        System.out.println("---------------------- dropDatabase ----------------------");
        client.dropDatabase(DBNAME);
    }

    private static CreateCollectionParam initCreateCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(1).withDescription("test sparse collection0").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", (Integer)EmbeddingModelEnum.BGE_BASE_ZH.getDimension(), IndexType.HNSW, MetricType.IP, new HNSWParams(16, 200))).addField(new SparseVectorIndex("sparse_vector", IndexType.INVERTED, MetricType.IP)).addField(new FilterIndex("bookName", FieldType.String, IndexType.FILTER)).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).build();
    }
}

