/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvdbtext.encoder.SparseVectorBm25Encoder;
import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.AutoIdType;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.SparseVectorIndex;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class VectorDBWithAutoIdAndJsonExample {
    private static final String DBNAME = "java_sdk_test_db";
    private static final String COLL_NAME = "auto_id_json_coll";

    public static void main(String[] args) throws InterruptedException {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBWithAutoIdAndJsonExample.createDatabaseAndCollection(client);
        VectorDBWithAutoIdAndJsonExample.upsertData(client);
        VectorDBWithAutoIdAndJsonExample.queryData(client);
        VectorDBWithAutoIdAndJsonExample.updateAndDelete(client);
        VectorDBWithAutoIdAndJsonExample.deleteAndDrop(client);
    }

    private static void updateAndDelete(VectorDBClient client) throws InterruptedException {
        System.out.println("---------------------- query ----------------------");
        QueryParam queryParam = QueryParam.newBuilder().withLimit(5L).withOffset(0L).addAllOutputFields("id", "bookInfo").build();
        List<Document> qdos = client.query(DBNAME, COLL_NAME, queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- update ----------------------");
        List<String> documentIds = Arrays.asList("87F9375D-F35D-439F-746E-DE9020293E42", "5F7BC75F-0193-4CD9-0D68-2F829A69E332");
        UpdateParam updateParam = ((UpdateParam.Builder)UpdateParam.newBuilder().withFilter("bookInfo.bookName=\"\u897f\u6e38\u8bb0\"")).build();
        Document updateDoc = Document.newBuilder().addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u897f\u6e38\u8bb0");
                this.put("page", 21);
                this.put("author", "\u5434\u627f\u6069_update");
            }
        }))).build();
        AffectRes affectRes = client.update(DBNAME, COLL_NAME, updateParam, updateDoc);
        System.out.println(affectRes.toString());
        Thread.sleep(2000L);
        System.out.println("---------------------- query ----------------------");
        queryParam = QueryParam.newBuilder().withLimit(5L).withOffset(0L).addAllOutputFields("id", "bookInfo").build();
        qdos = client.query(DBNAME, COLL_NAME, queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------delete-------");
        DeleteParam deleteParam = ((DeleteParam.Builder)DeleteParam.newBuilder().withFilter("bookInfo.bookName=\"\u897f\u6e38\u8bb0\"")).build();
        AffectRes res = client.delete(DBNAME, COLL_NAME, deleteParam);
        System.out.println("delete res: " + JsonUtils.toJsonString(res));
        System.out.println("---------after delete query-------");
        queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withLimit(5L).withFilter("bookInfo.bookName=\"\u4e09\u56fd\u6f14\u4e49\"")).withOffset(0L).addAllOutputFields("id", "bookInfo").build();
        qdos = client.query(DBNAME, COLL_NAME, queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabase(DBNAME);
        System.out.println("---------------------- listCollections ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBWithAutoIdAndJsonExample.initCreateCollectionParam(COLL_NAME);
        db.createCollection(collectionParam);
        System.out.println("auto_id_json_coll exists: " + db.IsExistsCollection(COLL_NAME));
        List<Collection> collectionInfos = client.listCollections(DBNAME);
        System.out.println("-------list collection-------");
        System.out.println(JsonUtils.toJsonString(collectionInfos));
    }

    private static void upsertData(VectorDBClient client) throws InterruptedException {
        List<String> texts = Arrays.asList("\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93\uff08Tencent Cloud VectorDB\uff09\u662f\u4e00\u6b3e\u5168\u6258\u7ba1\u7684\u81ea\u7814\u4f01\u4e1a\u7ea7\u5206\u5e03\u5f0f\u6570\u636e\u5e93\u670d\u52a1\uff0c\u4e13\u7528\u4e8e\u5b58\u50a8\u3001\u7d22\u5f15\u3001\u68c0\u7d22\u3001\u7ba1\u7406\u7531\u6df1\u5ea6\u795e\u7ecf\u7f51\u7edc\u6216\u5176\u4ed6\u673a\u5668\u5b66\u4e60\u6a21\u578b\u751f\u6210\u7684\u5927\u91cf\u591a\u7ef4\u5d4c\u5165\u5411\u91cf\u3002", "\u4f5c\u4e3a\u4e13\u95e8\u4e3a\u5904\u7406\u8f93\u5165\u5411\u91cf\u67e5\u8be2\u800c\u8bbe\u8ba1\u7684\u6570\u636e\u5e93\uff0c\u5b83\u652f\u6301\u591a\u79cd\u7d22\u5f15\u7c7b\u578b\u548c\u76f8\u4f3c\u5ea6\u8ba1\u7b97\u65b9\u6cd5\uff0c\u5355\u7d22\u5f15\u652f\u630110\u4ebf\u7ea7\u5411\u91cf\u89c4\u6a21\uff0c\u9ad8\u8fbe\u767e\u4e07\u7ea7 QPS \u53ca\u6beb\u79d2\u7ea7\u67e5\u8be2\u5ef6\u8fdf\u3002", "\u4e0d\u4ec5\u80fd\u4e3a\u5927\u6a21\u578b\u63d0\u4f9b\u5916\u90e8\u77e5\u8bc6\u5e93\uff0c\u63d0\u9ad8\u5927\u6a21\u578b\u56de\u7b54\u7684\u51c6\u786e\u6027\uff0c\u8fd8\u53ef\u5e7f\u6cdb\u5e94\u7528\u4e8e\u63a8\u8350\u7cfb\u7edf\u3001NLP \u670d\u52a1\u3001\u8ba1\u7b97\u673a\u89c6\u89c9\u3001\u667a\u80fd\u5ba2\u670d\u7b49 AI \u9886\u57df\u3002", "\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93\uff08Tencent Cloud VectorDB\uff09\u4f5c\u4e3a\u4e00\u79cd\u4e13\u95e8\u5b58\u50a8\u548c\u68c0\u7d22\u5411\u91cf\u6570\u636e\u7684\u670d\u52a1\u63d0\u4f9b\u7ed9\u7528\u6237\uff0c \u5728\u9ad8\u6027\u80fd\u3001\u9ad8\u53ef\u7528\u3001\u5927\u89c4\u6a21\u3001\u4f4e\u6210\u672c\u3001\u7b80\u5355\u6613\u7528\u3001\u7a33\u5b9a\u53ef\u9760\u7b49\u65b9\u9762\u4f53\u73b0\u51fa\u663e\u8457\u4f18\u52bf\u3002 ", "\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93\u53ef\u4ee5\u548c\u5927\u8bed\u8a00\u6a21\u578b LLM \u914d\u5408\u4f7f\u7528\u3002\u4f01\u4e1a\u7684\u79c1\u57df\u6570\u636e\u5728\u7ecf\u8fc7\u6587\u672c\u5206\u5272\u3001\u5411\u91cf\u5316\u540e\uff0c\u53ef\u4ee5\u5b58\u50a8\u5728\u817e\u8baf\u4e91\u5411\u91cf\u6570\u636e\u5e93\u4e2d\uff0c\u6784\u5efa\u8d77\u4f01\u4e1a\u4e13\u5c5e\u7684\u5916\u90e8\u77e5\u8bc6\u5e93\uff0c\u4ece\u800c\u5728\u540e\u7eed\u7684\u68c0\u7d22\u4efb\u52a1\u4e2d\uff0c\u4e3a\u5927\u6a21\u578b\u63d0\u4f9b\u63d0\u793a\u4fe1\u606f\uff0c\u8f85\u52a9\u5927\u6a21\u578b\u751f\u6210\u66f4\u52a0\u51c6\u786e\u7684\u7b54\u6848\u3002");
        List sparseVectors = SparseVectorBm25Encoder.getDefaultBm25Encoder().encodeTexts(texts);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(0)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u897f\u6e38\u8bb0");
                this.put("page", 24);
                this.put("author", "\u5434\u627f\u6069");
            }
        }))).build(), Document.newBuilder().withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(1)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u897f\u6e38\u8bb0");
                this.put("page", 22);
                this.put("author", "\u5434\u627f\u6069");
                this.put("array", Arrays.asList("test_6", "test_7", "test_3"));
            }
        }))).build(), Document.newBuilder().withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(2)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u4e09\u56fd\u6f14\u4e49");
                this.put("page", 23);
                this.put("author", "\u7f57\u8d2f\u4e2d");
                this.put("array", Arrays.asList("test_1", "test_5", "test_3"));
            }
        }))).build(), Document.newBuilder().withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(3)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u6c34\u6d52\u4f20");
                this.put("page", 24);
                this.put("author", "\u65bd\u8010\u5eb5");
                this.put("array", Arrays.asList("test_1", "test_2", "test_4"));
            }
        }))).build(), Document.newBuilder().withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(4)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u7ea2\u697c\u68a6");
                this.put("page", 25);
                this.put("author", "\u66f9\u96ea\u82b9");
                this.put("array", Arrays.asList("test_1", "test_2", "test_3"));
            }
        }))).build(), Document.newBuilder().withVector(CommonService.generateRandomVector(768)).withSparseVector((List)sparseVectors.get(0)).addDocField(new DocField("bookInfo", new JSONObject((Map)new HashMap<Object, Object>(){
            {
                this.put("bookName", "\u7ea2\u697c\u68a6");
                this.put("page", 26);
                this.put("author", "\u66f9\u96ea\u82b9");
                this.put("array", Arrays.asList("test_4", "test_2", "test_6"));
            }
        }))).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().withDocuments(documentList).build();
        AffectRes affectRes = client.upsert(DBNAME, COLL_NAME, insertParam);
        System.out.println(JsonUtils.toJsonString(affectRes));
        Thread.sleep(5000L);
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        QueryParam queryParam = ((QueryParam.Builder)QueryParam.newBuilder().withLimit(5L).withFilter("bookInfo.bookName=\"\u4e09\u56fd\u6f14\u4e49\"")).withOffset(0L).addAllOutputFields("id", "bookInfo").build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- searchById ----------------------");
        SearchByIdParam searchByIdParam = ((SearchByIdParam.Builder)((SearchByIdParam.Builder)SearchByIdParam.newBuilder().withDocumentIds(Arrays.asList(qdos.get(0).getId(), "0001")).withParams(new HNSWSearchParams(100))).withLimit(2)).build();
        List<List<Document>> siDocs = client.searchById(DBNAME, COLL_NAME, searchByIdParam);
        int i = 0;
        for (List<Document> docs : siDocs) {
            System.out.println("\tres: " + i++);
            for (Document document : docs) {
                System.out.println("\tres: " + document.toString());
            }
        }
        System.out.println("---------------------- search ----------------------");
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().addVector(CommonService.generateRandomVector(768)).withParams(new HNSWSearchParams(100))).withLimit(10)).build();
        List<List<Document>> svDocs = client.search(DBNAME, COLL_NAME, searchByVectorParam);
        i = 0;
        for (List list : svDocs) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc : list) {
                System.out.println("\tres: " + doc.toString());
            }
        }
    }

    private static void deleteAndDrop(VectorDBClient client) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- truncate collection ----------------------");
        database.dropCollection(COLL_NAME);
        System.out.println("---------------------- drop database ----------------------");
        client.dropDatabase(DBNAME);
    }

    private static CreateCollectionParam initCreateCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(1).withDescription("test json collection").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY, AutoIdType.UUID)).addField(new VectorIndex("vector", (Integer)EmbeddingModelEnum.BGE_BASE_ZH.getDimension(), IndexType.HNSW, MetricType.IP, new HNSWParams(16, 200))).addField(new SparseVectorIndex("sparse_vector", IndexType.INVERTED, MetricType.IP)).addField(new FilterIndex("bookInfo", FieldType.Json, IndexType.FILTER)).addField(new FilterIndex("array_test", FieldType.Array, IndexType.FILTER)).build();
    }
}

