/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.FilterIndexConfig;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.utils.BinaryUtils;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorDBWithBinaryVectorExample {
    private static final String DBNAME = "book_binary";
    private static final String COLL_NAME = "book__binary_collection";

    public static void main(String[] args) throws InterruptedException {
        VectorDBClient client = CommonService.initClient();
        CommonService.anySafe(() -> client.dropDatabase(DBNAME));
        VectorDBWithBinaryVectorExample.createDatabaseAndCollection(client);
        VectorDBWithBinaryVectorExample.upsertData(client);
        VectorDBWithBinaryVectorExample.queryData(client);
        VectorDBWithBinaryVectorExample.deleteAndDrop(client);
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabase(DBNAME);
        System.out.println("---------------------- listCollections ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- createCollection ----------------------");
        CreateCollectionParam collectionParam = VectorDBWithBinaryVectorExample.initCreateCollectionParam(COLL_NAME);
        db.createCollection(collectionParam);
        System.out.println("book__binary_collection exists: " + db.IsExistsCollection(COLL_NAME));
    }

    private static void upsertData(VectorDBClient client) throws InterruptedException {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").withVector(BinaryUtils.binaryToUint8(Arrays.asList(1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0))).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).build(), Document.newBuilder().withId("0002").withVector(BinaryUtils.binaryToUint8(Arrays.asList(1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0))).addDocField(new DocField("bookName", "\u897f\u6e38\u8bb0")).addDocField(new DocField("author", "\u5434\u627f\u6069")).build(), Document.newBuilder().withId("0003").withVector(BinaryUtils.binaryToUint8(Arrays.asList(0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0))).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).build(), Document.newBuilder().withId("0004").withVector(BinaryUtils.binaryToUint8(Arrays.asList(0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0))).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).build(), Document.newBuilder().withId("0005").withVector(BinaryUtils.binaryToUint8(Arrays.asList(0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0))).addDocField(new DocField("bookName", "\u4e09\u56fd\u6f14\u4e49")).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().withDocuments(documentList).build();
        AffectRes affectRes = client.upsert(DBNAME, COLL_NAME, insertParam);
        System.out.println(JsonUtils.toJsonString(affectRes));
        Thread.sleep(5000L);
    }

    private static void queryData(VectorDBClient client) {
        Database database = client.database(DBNAME);
        Collection collection = database.describeCollection(COLL_NAME);
        System.out.println("---------------------- query ----------------------");
        List<String> documentIds = Arrays.asList("0001", "0002", "0003", "0004", "0005");
        List<String> outputFields = Arrays.asList("id", "bookName");
        QueryParam queryParam = ((QueryParam.Builder)((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(Arrays.asList("0001", "0002", "0003", "0004", "0005"))).withLimit(5L).withFilter("bookName=\"\u4e09\u56fd\u6f14\u4e49\"")).withOffset(0L).addAllOutputFields("id", "bookName").withRetrieveVector(true).build();
        List<Document> qdos = collection.query(queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- searchById ----------------------");
        SearchByIdParam searchByIdParam = ((SearchByIdParam.Builder)((SearchByIdParam.Builder)SearchByIdParam.newBuilder().withDocumentIds(Arrays.asList("0001")).withParams(new HNSWSearchParams(100))).withLimit(2)).build();
        List<List<Document>> siDocs = client.searchById(DBNAME, COLL_NAME, searchByIdParam);
        int i = 0;
        for (List<Document> docs : siDocs) {
            System.out.println("\tres: " + i++);
            for (Document document : docs) {
                System.out.println("\tres: " + document.toString());
            }
        }
        System.out.println("---------------------- search ----------------------");
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().addVector(BinaryUtils.binaryToUint8(Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1))).withParams(new HNSWSearchParams(100))).withLimit(10)).build();
        List<List<Document>> svDocs = client.search(DBNAME, COLL_NAME, searchByVectorParam);
        i = 0;
        for (List list : svDocs) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc : list) {
                System.out.println("\tres: " + doc.toString());
            }
        }
    }

    private static void deleteAndDrop(VectorDBClient client) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- truncate collection ----------------------");
        database.dropCollection(COLL_NAME);
        System.out.println("---------------------- drop database ----------------------");
        client.dropDatabase(DBNAME);
    }

    private static CreateCollectionParam initCreateCollectionParam(String collName) {
        return CreateCollectionParam.newBuilder().withName(collName).withShardNum(1).withReplicaNum(1).withDescription("test binary collection").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", (Integer)16, FieldType.BinaryVector, IndexType.BIN_FLAT, MetricType.HAMMING)).withFilterIndexConfig(FilterIndexConfig.newBuilder().withFilterAll(true).withFieldWithoutFilterIndex(Arrays.asList("test1", "test2")).withMaxStrLen(64).build()).build();
    }
}

