/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.examples;

import com.tencent.tcvectordb.client.VectorDBClient;
import com.tencent.tcvectordb.examples.CommonService;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.Database;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.model.param.collection.FilterIndex;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IndexType;
import com.tencent.tcvectordb.model.param.collection.MetricType;
import com.tencent.tcvectordb.model.param.collection.VectorIndex;
import com.tencent.tcvectordb.model.param.dml.HNSWSearchParams;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.ModifyVectorIndexParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VectorDBWithHNSWQuantizationExample {
    private static final String DBNAME = "java_sdk_collection_hnsw_quantization";
    private static final String COLL_NAME_FLOAT16 = "sdk_collection_float16";
    private static final String COLL_NAME_BFLOAT16 = "sdk_collection_bfloat16";

    public static void main(String[] args) throws InterruptedException {
        VectorDBClient client = CommonService.initClient();
        VectorDBWithHNSWQuantizationExample.createDatabaseAndCollection(client);
        VectorDBWithHNSWQuantizationExample.upsertData(client, COLL_NAME_FLOAT16);
        VectorDBWithHNSWQuantizationExample.queryData(client, COLL_NAME_FLOAT16);
        VectorDBWithHNSWQuantizationExample.upsertData(client, COLL_NAME_BFLOAT16);
        VectorDBWithHNSWQuantizationExample.queryData(client, COLL_NAME_BFLOAT16);
        VectorDBWithHNSWQuantizationExample.modifyVectorIndex(client);
        VectorDBWithHNSWQuantizationExample.deleteAndDrop(client);
    }

    private static void createDatabaseAndCollection(VectorDBClient client) {
        System.out.println("---------------------- createDatabase ----------------------");
        Database db = client.createDatabaseIfNotExists(DBNAME);
        System.out.println("---------------------- listCollections ----------------------");
        List<String> database = client.listDatabase();
        for (String s : database) {
            System.out.println("\tres: " + s);
        }
        System.out.println("---------------------- create Float16 Collection ----------------------");
        CreateCollectionParam collectionParam = VectorDBWithHNSWQuantizationExample.initCreateCollectionParamFloat16(COLL_NAME_FLOAT16);
        client.createCollectionIfNotExists(DBNAME, collectionParam);
        System.out.println("sdk_collection_float16 collection: " + client.describeCollection(DBNAME, COLL_NAME_FLOAT16));
        System.out.println("---------------------- create BFloat16 Collection ----------------------");
        CreateCollectionParam collectionBFloat16Param = VectorDBWithHNSWQuantizationExample.initCreateCollectionParamBFloat16(COLL_NAME_BFLOAT16);
        client.createCollectionIfNotExists(DBNAME, collectionBFloat16Param);
        System.out.println("sdk_collection_bfloat16 collection: " + client.describeCollection(DBNAME, COLL_NAME_BFLOAT16));
    }

    private static CreateCollectionParam initCreateCollectionParamFloat16(String collNameFloat16) {
        return CreateCollectionParam.newBuilder().withName(collNameFloat16).withShardNum(1).withReplicaNum(1).withDescription("test float16 collection").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", 32, FieldType.Float16Vector, IndexType.HNSW, MetricType.IP, new HNSWParams(16, 200))).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).build();
    }

    private static CreateCollectionParam initCreateCollectionParamBFloat16(String collNameBFloat16) {
        return CreateCollectionParam.newBuilder().withName(collNameBFloat16).withShardNum(1).withReplicaNum(1).withDescription("test bfloat16 collection").addField(new FilterIndex("id", FieldType.String, IndexType.PRIMARY_KEY)).addField(new VectorIndex("vector", 32, FieldType.BFloat16Vector, IndexType.HNSW, MetricType.IP, new HNSWParams(16, 200))).addField(new FilterIndex("author", FieldType.String, IndexType.FILTER)).build();
    }

    private static void modifyVectorIndex(VectorDBClient client) throws InterruptedException {
        System.out.println("--------modify vector index collection: COLL_NAME_BFLOAT16 -------");
        Collection collection = client.describeCollection(DBNAME, COLL_NAME_BFLOAT16);
        System.out.println("before");
        System.out.println(JsonUtils.toJsonString(collection));
        BaseRes baseRes = client.modifyVectorIndex(DBNAME, COLL_NAME_BFLOAT16, ModifyVectorIndexParam.newBuilder().withVectorIndex(new VectorIndex(MetricType.IP, FieldType.Float16Vector, new HNSWParams(16, 200))).withRebuildRules(RebuildIndexParam.newBuilder().withDropBeforeRebuild(true).withThrottle(1).build()).build());
        System.out.println("modify res: " + JsonUtils.toJsonString(baseRes));
        Collection collectionAfter = client.describeCollection(DBNAME, COLL_NAME_BFLOAT16);
        System.out.println("after");
        System.out.println(JsonUtils.toJsonString(collectionAfter));
        System.out.println("--------modify vector index collection: COLL_NAME_BFLOAT16 -------");
        collection = client.describeCollection(DBNAME, COLL_NAME_FLOAT16);
        System.out.println("before");
        System.out.println(JsonUtils.toJsonString(collection));
        baseRes = client.modifyVectorIndex(DBNAME, COLL_NAME_BFLOAT16, ModifyVectorIndexParam.newBuilder().withVectorIndex(new VectorIndex(MetricType.IP, FieldType.BFloat16Vector, new HNSWParams(16, 200))).withRebuildRules(RebuildIndexParam.newBuilder().withDropBeforeRebuild(true).withThrottle(1).build()).build());
        System.out.println("modify res: " + JsonUtils.toJsonString(baseRes));
        collectionAfter = client.describeCollection(DBNAME, COLL_NAME_BFLOAT16);
        System.out.println("after");
        System.out.println(JsonUtils.toJsonString(collectionAfter));
    }

    private static void upsertData(VectorDBClient client, String collectionName) throws InterruptedException {
        Database database = client.database(DBNAME);
        ArrayList<Document> documentList = new ArrayList<Document>(Arrays.asList(Document.newBuilder().withId("0001").withVector(CommonService.generateRandomVector(32)).addDocField(new DocField("author", "\u5434\u627f\u6069")).build(), Document.newBuilder().withId("0002").withVector(CommonService.generateRandomVector(32)).addDocField(new DocField("author", "\u5434\u627f\u6069")).build(), Document.newBuilder().withId("0003").withVector(CommonService.generateRandomVector(32)).addDocField(new DocField("author", "\u5434\u627f\u6069")).build(), Document.newBuilder().withId("0004").withVector(CommonService.generateRandomVector(32)).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).build(), Document.newBuilder().withId("0005").withVector(CommonService.generateRandomVector(32)).addDocField(new DocField("author", "\u7f57\u8d2f\u4e2d")).build()));
        System.out.println("---------------------- upsert ----------------------");
        InsertParam insertParam = InsertParam.newBuilder().withDocuments(documentList).build();
        AffectRes affectRes = client.upsert(DBNAME, collectionName, insertParam);
        System.out.println(JsonUtils.toJsonString(affectRes));
        affectRes = client.upsert(DBNAME, collectionName, insertParam);
        System.out.println(JsonUtils.toJsonString(affectRes));
    }

    private static void queryData(VectorDBClient client, String collectionName) {
        Database database = client.database(DBNAME);
        System.out.println("---------------------- query ----------------------");
        QueryParam queryParam = ((QueryParam.Builder)((QueryParam.Builder)QueryParam.newBuilder().withDocumentIds(Arrays.asList("0001", "0002", "0003", "0004", "0005"))).withLimit(5L).withFilter("author=\"\u5434\u627f\u6069\"")).withOffset(0L).addAllOutputFields("id", "author").withRetrieveVector(true).build();
        List<Document> qdos = client.query(DBNAME, collectionName, queryParam);
        for (Document doc : qdos) {
            System.out.println("\tres: " + doc.toString());
        }
        System.out.println("---------------------- searchById ----------------------");
        SearchByIdParam searchByIdParam = ((SearchByIdParam.Builder)((SearchByIdParam.Builder)SearchByIdParam.newBuilder().withDocumentIds(Arrays.asList("0001")).withParams(new HNSWSearchParams(100))).withLimit(2)).build();
        List<List<Document>> siDocs = client.searchById(DBNAME, collectionName, searchByIdParam);
        int i = 0;
        for (List<Document> docs : siDocs) {
            System.out.println("\tres: " + i++);
            for (Document document : docs) {
                System.out.println("\tres: " + document.toString());
            }
        }
        System.out.println("---------------------- search ----------------------");
        SearchByVectorParam searchByVectorParam = ((SearchByVectorParam.Builder)((SearchByVectorParam.Builder)SearchByVectorParam.newBuilder().addVector(CommonService.generateRandomVector(32)).withParams(new HNSWSearchParams(100))).withLimit(10)).build();
        List<List<Document>> svDocs = client.search(DBNAME, collectionName, searchByVectorParam);
        i = 0;
        for (List list : svDocs) {
            System.out.println("\tres: " + i);
            ++i;
            for (Document doc : list) {
                System.out.println("\tres: " + doc.toString());
            }
        }
    }

    private static void deleteAndDrop(VectorDBClient client) {
        System.out.println("---------------------- drop database ----------------------");
        client.dropDatabase(DBNAME);
    }
}

