/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.collection.FilterIndexConfig;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collection.TTLConfig;
import com.tencent.tcvectordb.model.param.dml.AddIndexParam;
import com.tencent.tcvectordb.model.param.dml.CountQueryParam;
import com.tencent.tcvectordb.model.param.dml.DeleteParam;
import com.tencent.tcvectordb.model.param.dml.HybridSearchParam;
import com.tencent.tcvectordb.model.param.dml.InsertParam;
import com.tencent.tcvectordb.model.param.dml.ModifyVectorIndexParam;
import com.tencent.tcvectordb.model.param.dml.QueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByEmbeddingItemsParam;
import com.tencent.tcvectordb.model.param.dml.SearchByIdParam;
import com.tencent.tcvectordb.model.param.dml.SearchByVectorParam;
import com.tencent.tcvectordb.model.param.dml.UpdateParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.HybridSearchRes;
import com.tencent.tcvectordb.model.param.entity.SearchRes;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.AddIndexParamInner;
import com.tencent.tcvectordb.service.param.DeleteParamInner;
import com.tencent.tcvectordb.service.param.HybridSearchParamInner;
import com.tencent.tcvectordb.service.param.InsertParamInner;
import com.tencent.tcvectordb.service.param.ModifyIndexParamInner;
import com.tencent.tcvectordb.service.param.QueryCountParamInner;
import com.tencent.tcvectordb.service.param.QueryParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchParamInner;
import com.tencent.tcvectordb.service.param.UpdateParamInner;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Collection {
    @JsonIgnore
    private Stub stub;
    protected String database;
    protected String collection;
    protected int replicaNum = 2;
    protected int shardNum = 1;
    protected String description;
    protected List<IndexField> indexes;
    private String createTime;
    @JsonIgnore
    protected ReadConsistencyEnum readConsistency;
    private long documentCount;
    private IndexStatus indexStatus;
    private List<String> alias;
    protected Embedding embedding;
    protected TTLConfig ttlConfig;
    protected FilterIndexConfig filterIndexConfig;
    @JsonIgnore
    private String connectCollectionName;

    public void setConnectCollectionName(String connectCollectionName) {
        this.connectCollectionName = connectCollectionName;
    }

    public TTLConfig getTtlConfig() {
        return this.ttlConfig;
    }

    public void setTtlConfig(TTLConfig ttlConfig) {
        this.ttlConfig = ttlConfig;
    }

    public FilterIndexConfig getFilterIndexConfig() {
        return this.filterIndexConfig;
    }

    public void setFilterIndexConfig(FilterIndexConfig filterIndexConfig) {
        this.filterIndexConfig = filterIndexConfig;
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getReplicaNum() {
        return this.replicaNum;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public String getDescription() {
        return this.description;
    }

    public List<IndexField> getIndexes() {
        return this.indexes;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public long getDocumentCount() {
        return this.documentCount;
    }

    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ReadConsistencyEnum readConsistency) {
        this.readConsistency = readConsistency;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setReplicaNum(int replicaNum) {
        this.replicaNum = replicaNum;
    }

    public void setShardNum(int shardNum) {
        this.shardNum = shardNum;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIndexes(List<IndexField> indexes) {
        this.indexes = indexes;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setDocumentCount(long documentCount) {
        this.documentCount = documentCount;
    }

    public void setIndexStatus(IndexStatus indexStatus2) {
        this.indexStatus = indexStatus2;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    public Embedding getEmbedding() {
        return this.embedding;
    }

    public void setEmbedding(Embedding embedding) {
        this.embedding = embedding;
    }

    public AffectRes upsert(InsertParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        InsertParamInner insertParam = new InsertParamInner(this.database, collection, param);
        boolean ai = false;
        if (param.getDocuments().get(0) != null) {
            if (param.getDocuments().get(0) instanceof Document && ((Document)param.getDocuments().get(0)).getVector() instanceof String) {
                ai = true;
            }
            if (param.getDocuments().get(0) instanceof JSONObject && ((JSONObject)param.getDocuments().get(0)).get("vector") instanceof String) {
                ai = true;
            }
        }
        return this.stub.upsertDocument(insertParam, ai);
    }

    public List<Document> query(QueryParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        boolean ai = false;
        return this.stub.queryDocument(new QueryParamInner(this.database, collection, param, this.readConsistency), ai);
    }

    public List<List<Document>> search(SearchByVectorParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.searchDocument(new SearchParamInner(this.database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE).getDocuments();
    }

    public List<List<Document>> searchById(SearchByIdParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.searchDocument(new SearchParamInner(this.database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE).getDocuments();
    }

    public SearchRes searchByEmbeddingItems(SearchByEmbeddingItemsParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.searchDocument(new SearchParamInner(this.database, collection, param, this.readConsistency), DataBaseTypeEnum.BASE);
    }

    public HybridSearchRes hybridSearch(HybridSearchParam param) throws VectorDBException {
        boolean ai = false;
        if (param.getAnn() != null && !param.getAnn().isEmpty() && param.getAnn().get(0).getData() != null && !param.getAnn().get(0).getData().isEmpty() && param.getAnn().get(0).getData().get(0) instanceof String) {
            ai = true;
        }
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.hybridSearchDocument(new HybridSearchParamInner(this.database, collection, param, this.readConsistency), ai);
    }

    public AffectRes delete(DeleteParam param) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.deleteDocument(new DeleteParamInner(this.database, collection, param));
    }

    public AffectRes update(UpdateParam param, Document document) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        boolean ai = false;
        if (document.getVector() instanceof String) {
            ai = true;
        }
        return this.stub.updateDocument(new UpdateParamInner(this.database, collection, param, document), ai);
    }

    public AffectRes update(UpdateParam param, JSONObject document) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        boolean ai = false;
        if (document.get("vector") instanceof String) {
            ai = true;
        }
        return this.stub.updateDocument(new UpdateParamInner(this.database, collection, param, document), ai);
    }

    public BaseRes rebuildIndex(RebuildIndexParam rebuildIndexParam) {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.rebuildIndex(new RebuildIndexParamInner(this.database, collection, rebuildIndexParam));
    }

    @Deprecated
    public BaseRes AddIndex(String database, String collection, AddIndexParam addIndexParam) throws VectorDBException {
        return this.stub.addIndex(new AddIndexParamInner(database, collection, addIndexParam));
    }

    public BaseRes addIndex(String database, String collection, AddIndexParam addIndexParam) throws VectorDBException {
        return this.stub.addIndex(new AddIndexParamInner(database, collection, addIndexParam));
    }

    public BaseRes addIndex(AddIndexParam addIndexParam) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.addIndex(new AddIndexParamInner(this.database, collection, addIndexParam));
    }

    public BaseRes count(CountQueryParam countQueryParam) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.countDocument(new QueryCountParamInner(this.database, collection, countQueryParam, this.readConsistency), false);
    }

    public BaseRes modifyVectorIndex(ModifyVectorIndexParam modifyVectorIndexParam) throws VectorDBException {
        String collection = this.collection;
        if (this.connectCollectionName != null) {
            collection = this.connectCollectionName;
        }
        return this.stub.modifyVectorIndex(new ModifyIndexParamInner(this.database, collection, modifyVectorIndexParam), false);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new ParamException(String.format("Create collection param error: %s", new Object[]{e}));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IndexStatus {
        private String status;
        private Date startTime;

        public String getStatus() {
            return this.status;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public IndexStatus() {
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public IndexStatus(String status, String startTime) {
            this.status = status;
            if (!startTime.isEmpty()) {
                String formatPattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat dateFormat = new SimpleDateFormat(formatPattern);
                try {
                    Date date;
                    this.startTime = date = dateFormat.parse(startTime);
                    System.out.println("Parsed Date: " + date);
                }
                catch (ParseException e) {
                    System.err.println("Failed to parse date: " + e.getMessage());
                }
            }
        }

        public String toString() {
            return "IndexStatus{status='" + this.status + '\'' + ", startTime=" + this.startTime + '}';
        }
    }
}

