/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.DocumentSet;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collectionView.EmbeddingParams;
import com.tencent.tcvectordb.model.param.collectionView.LoadAndSplitTextParam;
import com.tencent.tcvectordb.model.param.collectionView.ParsingProcessParam;
import com.tencent.tcvectordb.model.param.collectionView.SplitterPreprocessParams;
import com.tencent.tcvectordb.model.param.dml.CollectionViewConditionParam;
import com.tencent.tcvectordb.model.param.dml.CollectionViewQueryParam;
import com.tencent.tcvectordb.model.param.dml.RebuildIndexParam;
import com.tencent.tcvectordb.model.param.dml.SearchByContentsParam;
import com.tencent.tcvectordb.model.param.entity.AIStatus;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import com.tencent.tcvectordb.model.param.entity.DocumentFileContent;
import com.tencent.tcvectordb.model.param.entity.GetChunksRes;
import com.tencent.tcvectordb.model.param.entity.SearchContentInfo;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.service.param.CollectionViewDeleteParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewQueryParamInner;
import com.tencent.tcvectordb.service.param.CollectionViewUpdateParamInner;
import com.tencent.tcvectordb.service.param.RebuildIndexParamInner;
import com.tencent.tcvectordb.service.param.SearchDocParamInner;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CollectionView {
    @JsonIgnore
    private Stub stub;
    private String database;
    protected String collectionView;
    @JsonIgnore
    protected ReadConsistencyEnum readConsistency;
    protected String description;
    private String createTime;
    private AIStatus stats;
    protected SplitterPreprocessParams splitterPreprocess;
    protected EmbeddingParams embedding;
    protected Integer expectedFileNum;
    protected Integer averageFileSize;
    private List<String> alias;
    protected List<IndexField> indexes;
    protected ParsingProcessParam parsingProcess;
    @JsonIgnore
    private String connectCollectionName;
    protected Integer replicaNum;
    protected Integer shardNum;

    public void setConnectCollectionName(String connectCollectionName) {
        this.connectCollectionName = connectCollectionName;
    }

    public List<IndexField> getIndexes() {
        return this.indexes;
    }

    public String getCollectionView() {
        return this.collectionView;
    }

    public AIStatus getStats() {
        return this.stats;
    }

    public SplitterPreprocessParams getSplitterPreprocess() {
        return this.splitterPreprocess;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public Stub getStub() {
        return this.stub;
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ReadConsistencyEnum readConsistency) {
        this.readConsistency = readConsistency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public EmbeddingParams getEmbedding() {
        return this.embedding;
    }

    public void setEmbedding(EmbeddingParams embedding) {
        this.embedding = embedding;
    }

    public Integer getExpectedFileNum() {
        return this.expectedFileNum;
    }

    public void setExpectedFileNum(Integer expectedFileNum) {
        this.expectedFileNum = expectedFileNum;
    }

    public Integer getAverageFileSize() {
        return this.averageFileSize;
    }

    public void setAverageFileSize(Integer averageFileSize) {
        this.averageFileSize = averageFileSize;
    }

    public ParsingProcessParam getParsingProcess() {
        return this.parsingProcess;
    }

    public void setParsingProcess(ParsingProcessParam parsingProcess) {
        this.parsingProcess = parsingProcess;
    }

    public Integer getReplicaNum() {
        return this.replicaNum;
    }

    public void setReplicaNum(Integer replicaNum) {
        this.replicaNum = replicaNum;
    }

    public Integer getShardNum() {
        return this.shardNum;
    }

    public void setShardNum(Integer shardNum) {
        this.shardNum = shardNum;
    }

    public List<DocumentSet> query(CollectionViewQueryParam param) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, param, this.readConsistency));
        for (DocumentSet documentSet : documentSets) {
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        }
        return documentSets;
    }

    public List<DocumentSet> query() throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, CollectionViewQueryParam.newBuilder().build(), this.readConsistency));
        for (DocumentSet documentSet : documentSets) {
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        }
        return documentSets;
    }

    public List<DocumentSet> query(int limit) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, CollectionViewQueryParam.newBuilder().withLimit(limit).build(), this.readConsistency));
        for (DocumentSet documentSet : documentSets) {
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        }
        return documentSets;
    }

    public List<DocumentSet> query(int limit, int offset) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        List<DocumentSet> documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, CollectionViewQueryParam.newBuilder().withLimit(limit).withOffset(offset).build(), this.readConsistency));
        for (DocumentSet documentSet : documentSets) {
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
        }
        return documentSets;
    }

    public DocumentSet getDocumentSetByName(String documentSetName) throws VectorDBException {
        List<DocumentSet> documentSets;
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        if ((documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, ((CollectionViewQueryParam.Builder)CollectionViewQueryParam.newBuilder().withDocumentSetNames((List)Arrays.asList(documentSetName))).build(), this.readConsistency))).size() > 0) {
            DocumentSet documentSet = documentSets.get(0);
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
            return documentSet;
        }
        throw new VectorDBException("data not existed!");
    }

    public DocumentSet getDocumentSetById(String documentSetId) throws VectorDBException {
        List<DocumentSet> documentSets;
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        if ((documentSets = this.stub.queryAIDocument(new CollectionViewQueryParamInner(this.database, collectionView, ((CollectionViewQueryParam.Builder)CollectionViewQueryParam.newBuilder().withDocumentSetIds((List)Arrays.asList(documentSetId))).build(), this.readConsistency))).size() > 0) {
            DocumentSet documentSet = documentSets.get(0);
            documentSet.setCollectionViewName(collectionView);
            documentSet.setStub(this.stub);
            documentSet.setDatabase(this.database);
            return documentSet;
        }
        throw new VectorDBException("data not existed!");
    }

    public List<SearchContentInfo> search(SearchByContentsParam param) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.searchAIDocument(new SearchDocParamInner(this.database, collectionView, param, this.readConsistency)).getDocuments();
    }

    public AffectRes deleteDocumentSets(CollectionViewConditionParam param) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, collectionView, param));
    }

    public AffectRes deleteByDocumentSetName(String documentSetName) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, collectionView, CollectionViewConditionParam.newBuilder().withDocumentSetNames(Arrays.asList(documentSetName)).build()));
    }

    public AffectRes deleteByDocumentSetId(String documentSetId) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.deleteAIDocument(new CollectionViewDeleteParamInner(this.database, collectionView, CollectionViewConditionParam.newBuilder().withDocumentSetIds(Arrays.asList(documentSetId)).build()));
    }

    public AffectRes update(CollectionViewConditionParam param, Map<String, Object> updateFieldValues) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.updateAIDocument(new CollectionViewUpdateParamInner(this.database, collectionView, param, updateFieldValues));
    }

    public void loadAndSplitText(LoadAndSplitTextParam loadAndSplitTextParam, Map<String, Object> metaDataMap) throws Exception {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        this.stub.upload(this.database, collectionView, loadAndSplitTextParam, metaDataMap);
    }

    public void loadAndSplitText(LoadAndSplitTextParam loadAndSplitTextParam) throws Exception {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        this.stub.upload(this.database, collectionView, loadAndSplitTextParam, Collections.EMPTY_MAP);
    }

    public DocumentFileContent getFile(String fileName, String fileId) {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.getFile(this.database, collectionView, fileName, fileId).getDocumentSet();
    }

    public BaseRes rebuildIndex(RebuildIndexParam rebuildIndexParam) throws VectorDBException {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.rebuildAIIndex(new RebuildIndexParamInner(this.database, collectionView, rebuildIndexParam));
    }

    public GetChunksRes getChunks(String documentSetName, Integer limit, Integer offset) {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.getChunks(this.database, collectionView, documentSetName, null, limit, offset);
    }

    public GetChunksRes getChunks(String documentSetName) {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.getChunks(this.database, collectionView, documentSetName, null, null, null);
    }

    public GetChunksRes getChunks(String documentSetId, String documentSetName, Integer limit, Integer offset) {
        String collectionView = this.collectionView;
        if (this.connectCollectionName != null) {
            collectionView = this.connectCollectionName;
        }
        return this.stub.getChunks(this.database, collectionView, documentSetName, documentSetId, limit, offset);
    }

    public String toString() {
        return JsonUtils.toJsonString(this);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class IndexStatus {
        private String status;
        private Date startTime;

        public String getStatus() {
            return this.status;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return "IndexStatus{status='" + this.status + '\'' + ", startTime=" + this.startTime + '}';
        }
    }
}

