/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Collection;
import com.tencent.tcvectordb.model.param.collection.CreateCollectionParam;
import com.tencent.tcvectordb.model.param.entity.AffectRes;
import com.tencent.tcvectordb.model.param.entity.DataBaseType;
import com.tencent.tcvectordb.model.param.enums.DataBaseTypeEnum;
import com.tencent.tcvectordb.model.param.enums.ReadConsistencyEnum;
import com.tencent.tcvectordb.service.Stub;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Database {
    @JsonIgnore
    private final Stub stub;
    @JsonProperty(value="database")
    private final String databaseName;
    @JsonIgnore
    private final ReadConsistencyEnum readConsistency;

    public Database(Stub stub, String databaseName, ReadConsistencyEnum readConsistency) {
        this.stub = stub;
        this.databaseName = databaseName;
        this.readConsistency = readConsistency;
    }

    private void ensureDataBaseType() throws VectorDBException {
        Map<String, DataBaseType> dataBaseTypeMap = this.stub.listDatabaseInfos();
        if (!dataBaseTypeMap.containsKey(this.databaseName)) {
            throw new VectorDBException("database not existed");
        }
        if (DataBaseTypeEnum.isAIDataBase(DataBaseTypeEnum.valueOf(dataBaseTypeMap.get(this.databaseName).getDbType()))) {
            throw new VectorDBException("database is ai database");
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ReadConsistencyEnum getReadConsistency() {
        return this.readConsistency;
    }

    public Collection createCollection(CreateCollectionParam param) throws VectorDBException {
        param.setDatabase(this.databaseName);
        param.setReadConsistency(this.readConsistency);
        this.stub.createCollection(param);
        param.setStub(this.stub);
        return param;
    }

    public Collection createCollectionIfNotExists(CreateCollectionParam param) throws VectorDBException {
        Collection collections = null;
        try {
            collections = this.stub.describeCollection(this.databaseName, param.getCollection());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setDatabase(this.databaseName);
        param.setReadConsistency(this.readConsistency);
        if (collections == null) {
            this.stub.createCollection(param);
        }
        param.setStub(this.stub);
        return param;
    }

    public List<Collection> listCollections() throws VectorDBException {
        List<Collection> collections = this.stub.listCollections(this.databaseName);
        collections.forEach(c -> {
            c.setStub(this.stub);
            c.setReadConsistency(this.readConsistency);
        });
        return collections;
    }

    @Deprecated
    public Boolean existsCollection(String collection) throws VectorDBException {
        Collection collectionInfo = null;
        try {
            collectionInfo = this.stub.describeCollection(this.databaseName, collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collectionInfo != null;
    }

    public Boolean IsExistsCollection(String collection) throws VectorDBException {
        Collection collectionInfo = null;
        try {
            collectionInfo = this.stub.describeCollection(this.databaseName, collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collectionInfo != null;
    }

    public AffectRes truncateCollections(String collectionName) {
        return this.stub.truncateCollection(this.databaseName, collectionName, DataBaseTypeEnum.BASE_DB);
    }

    public Collection describeCollection(String collectionName) throws VectorDBException {
        Collection collection = this.stub.describeCollection(this.databaseName, collectionName);
        collection.setStub(this.stub);
        collection.setConnectCollectionName(collectionName);
        collection.setReadConsistency(this.readConsistency);
        return collection;
    }

    public void dropCollection(String collectionName) throws VectorDBException {
        this.stub.dropCollection(this.databaseName, collectionName);
    }

    public AffectRes setAlias(String collectionName, String aliasName) {
        return this.stub.setAlias(this.databaseName, collectionName, aliasName);
    }

    public AffectRes deleteAlias(String aliasName) {
        return this.stub.deleteAlias(this.databaseName, aliasName);
    }

    public Collection collection(String collectionName) throws VectorDBException {
        return this.describeCollection(collectionName);
    }

    public String toString() {
        return JsonUtils.toJsonString(this);
    }
}

