/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.param.collection.FieldType;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class DocField {
    private final String name;
    private final Object value;

    public DocField(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getStringValue() {
        return this.value.toString();
    }

    @JsonIgnore
    public FieldType getFieldType() {
        if (this.value == null) {
            throw new VectorDBException("DocField value is null, filed name is " + this.name);
        }
        String valueClassName = this.value.getClass().getName();
        if (valueClassName.equals("java.lang.Integer") || valueClassName.equals("java.lang.Long")) {
            return FieldType.Uint64;
        }
        if (this.value instanceof List) {
            return FieldType.Array;
        }
        if (this.value instanceof JSONObject) {
            return FieldType.Json;
        }
        return FieldType.String;
    }

    public static String fillDocFiledsJsonString(ObjectNode node, List<DocField> docFields) {
        if (docFields != null && !docFields.isEmpty()) {
            for (DocField field : docFields) {
                String valueClassName = field.getValue().getClass().getName();
                if (valueClassName.equals("java.lang.Integer") || valueClassName.equals("java.lang.Long")) {
                    node.put(field.getName(), Long.valueOf(field.getStringValue()));
                    continue;
                }
                if (valueClassName.equals("java.lang.Float") || valueClassName.equals("java.lang.Double")) {
                    node.put(field.getName(), Double.valueOf(field.getStringValue()));
                    continue;
                }
                if (field.getValue() instanceof List) {
                    List strValues = (List)field.getValue();
                    ArrayNode strNode = JsonNodeFactory.instance.arrayNode();
                    strValues.forEach(arg_0 -> ((ArrayNode)strNode).add(arg_0));
                    node.set(field.getName(), (JsonNode)strNode);
                    continue;
                }
                if (field.getValue() instanceof JSONObject) {
                    Map map = JsonUtils.parseObject(field.getValue().toString(), Map.class);
                    JsonNode jsonNode = JsonUtils.toJsonNode(map);
                    node.set(field.getName(), jsonNode);
                    continue;
                }
                node.put(field.getName(), field.getStringValue());
            }
        }
        return node.toString();
    }
}

