/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.model.DocField;
import com.tencent.tcvectordb.utils.ConvertUtils;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Document {
    private String id;
    private Object vector;
    private List<Pair<Long, Float>> sparseVector;
    private Double score;
    private String doc;
    private List<DocField> docFields;
    private Map<String, Object> docKeyValue;

    public String getId() {
        return this.id;
    }

    public Double getScore() {
        return this.score;
    }

    public String getDoc() {
        return this.doc;
    }

    public List<DocField> getDocFields() {
        return this.docFields;
    }

    public Map<String, Object> getDocKeyValue() {
        return this.docKeyValue;
    }

    public Object getVector() {
        return this.vector;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVector(Object vector) {
        this.vector = vector;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public void setDocFields(List<DocField> docFields) {
        this.docFields = docFields;
    }

    public List<Pair<Long, Float>> getSparseVector() {
        return this.sparseVector;
    }

    public void setSparseVector(List<Pair<Long, Float>> sparseVector) {
        this.sparseVector = sparseVector;
    }

    public Object getObject(String key) {
        if (Objects.isNull(this.docFields) || this.docFields.isEmpty()) {
            return null;
        }
        this.ensureDocKeyValue();
        return this.docKeyValue.get(key);
    }

    private void ensureDocKeyValue() {
        if (Objects.isNull(this.docKeyValue)) {
            this.docKeyValue = new TreeMap<String, Object>();
            for (DocField docField : this.docFields) {
                this.docKeyValue.put(docField.getName(), docField.getValue());
            }
        }
    }

    public String toString() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            node.put("id", this.id);
        }
        if (this.vector != null) {
            if (this.vector instanceof List) {
                ArrayNode vectorNode = JsonNodeFactory.instance.arrayNode();
                ((List)this.vector).forEach(ele -> {
                    if (ele instanceof Number) {
                        vectorNode.add(((Number)ele).doubleValue());
                    }
                    if (ele instanceof String) {
                        vectorNode.add(ele.toString());
                    }
                });
                node.set("vector", (JsonNode)vectorNode);
            }
            if (this.vector instanceof String) {
                node.put("vector", this.vector.toString());
            }
        }
        if (this.sparseVector != null && !this.sparseVector.isEmpty()) {
            node.put("sparse_vector", JsonUtils.toJsonNode(ConvertUtils.convertPairToList(this.sparseVector)));
        }
        if (this.score != null) {
            node.put("score", this.score);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.doc)) {
            node.put("doc", this.doc);
        }
        return DocField.fillDocFiledsJsonString(node, this.docFields);
    }

    private Document(Builder builder) {
        this.id = builder.id;
        this.vector = builder.vector;
        this.doc = builder.doc;
        this.score = builder.score;
        this.docFields = builder.docFields;
        this.sparseVector = builder.sparseVector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private Object vector;
        private List<Pair<Long, Float>> sparseVector;
        private Double score;
        private String doc;
        private List<DocField> docFields = new ArrayList<DocField>();

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withVector(List<? extends Number> vector) {
            this.vector = vector;
            return this;
        }

        public Builder withVectorByEmbeddingText(String embeddingText) {
            this.vector = embeddingText;
            return this;
        }

        public Builder withDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder withScore(Double score) {
            this.score = score;
            return this;
        }

        public Builder withVectorByText(String embeddingText) {
            this.vector = embeddingText;
            return this;
        }

        public Builder withSparseVector(List<Pair<Long, Float>> sparseVector) {
            this.sparseVector = sparseVector;
            return this;
        }

        public Builder withSparseVectorList(List<Object> sparseVectors) {
            ArrayList<Pair<Long, Float>> sparseVectorTmp = new ArrayList<Pair<Long, Float>>();
            sparseVectors.forEach(sparseVector -> {
                if (sparseVector instanceof List) {
                    List sparseVectorList = (List)sparseVector;
                    sparseVectorTmp.add(Pair.of((Object)Long.valueOf(sparseVectorList.get(0).toString()), (Object)Float.valueOf(sparseVectorList.get(1).toString())));
                }
            });
            this.sparseVector = sparseVectorTmp;
            return this;
        }

        @Deprecated
        public Builder addFilterField(DocField field) {
            this.docFields.add(field);
            return this;
        }

        public Builder addDocField(DocField docField) {
            this.docFields.add(docField);
            return this;
        }

        public Builder addDocFields(List<DocField> docFields) {
            this.docFields.addAll(docFields);
            return this;
        }

        public Document build() {
            return new Document(this);
        }
    }
}

