/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.collection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvdbtext.exception.ParamException;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FilterIndexConfig {
    private boolean filterAll;
    private List<String> fieldsWithoutIndex = new ArrayList<String>();
    private Integer maxStrLen;

    public FilterIndexConfig() {
    }

    public FilterIndexConfig(Builder builder) {
        this.filterAll = builder.filterAll;
        this.fieldsWithoutIndex = builder.fieldWithoutFilterIndex;
        this.maxStrLen = builder.maxStrLen;
    }

    public boolean isFilterAll() {
        return this.filterAll;
    }

    public void setFilterAll(boolean filterAll) {
        this.filterAll = filterAll;
    }

    public List<String> getFieldsWithoutIndex() {
        return this.fieldsWithoutIndex;
    }

    public void setFieldsWithoutIndex(List<String> fieldsWithoutIndex) {
        this.fieldsWithoutIndex = fieldsWithoutIndex;
    }

    public Integer getMaxStrLen() {
        return this.maxStrLen;
    }

    public void setMaxStrLen(Integer maxStrLen) {
        this.maxStrLen = maxStrLen;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean filterAll;
        private List<String> fieldWithoutFilterIndex;
        private Integer maxStrLen = 32;

        private Builder() {
        }

        public Builder withFilterAll(boolean filterAll) {
            this.filterAll = filterAll;
            return this;
        }

        public Builder withFieldWithoutFilterIndex(List<String> fieldWithoutFilterIndex) {
            this.fieldWithoutFilterIndex = fieldWithoutFilterIndex;
            return this;
        }

        public Builder withMaxStrLen(Integer maxStrLen) {
            this.maxStrLen = maxStrLen;
            return this;
        }

        public FilterIndexConfig build() {
            if (this.maxStrLen != null && this.maxStrLen == 0) {
                throw new ParamException("The value of maxStrLen cannot be 0.");
            }
            return new FilterIndexConfig(this);
        }
    }
}

