/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.database;

import com.tencent.tcvectordb.exception.ParamException;
import org.apache.commons.lang3.StringUtils;

public class ConnectParam {
    private final String url;
    private final String username;
    private final String key;
    private final int timeout;
    private final int connectTimeout;
    private final int maxIdleConnections;
    private final int keepAliveDuration;

    private ConnectParam(Builder builder) {
        this.url = builder.url;
        this.username = builder.username;
        this.key = builder.key;
        this.timeout = builder.timeout;
        this.connectTimeout = builder.connectTimeout;
        this.maxIdleConnections = builder.maxIdleConnections;
        this.keepAliveDuration = builder.keepAliveDuration;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getKey() {
        return this.key;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public int getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String username;
        private String key;
        private int timeout = 10;
        private int connectTimeout = 10;
        private int maxIdleConnections = 10;
        private int keepAliveDuration = 300;

        private Builder() {
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withTimeout(int timeout) {
            if (timeout != 0) {
                this.timeout = timeout;
            }
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            if (connectTimeout > 0) {
                this.connectTimeout = connectTimeout;
            }
            return this;
        }

        public Builder withMaxIdleConnections(int maxIdleConnections) {
            if (maxIdleConnections > 0) {
                this.maxIdleConnections = maxIdleConnections;
            }
            return this;
        }

        public Builder withKeepAliveDuration(int keepAliveDuration) {
            if (keepAliveDuration > 0) {
                this.keepAliveDuration = keepAliveDuration;
            }
            return this;
        }

        public ConnectParam build() throws ParamException {
            if (StringUtils.isEmpty((CharSequence)this.url)) {
                throw new ParamException("ConnectParam error: url is null");
            }
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                throw new ParamException("ConnectParam error: username is null");
            }
            if (StringUtils.isEmpty((CharSequence)this.key)) {
                throw new ParamException("ConnectParam error: key is null");
            }
            return new ConnectParam(this);
        }

        public String toString() {
            return "Builder{url='" + this.url + '\'' + '}';
        }
    }
}

