/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.model.param.dml.Params;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnnOption {
    private String fieldName;
    private List<Object> data;
    private List<String> documentIds;
    private Params params;
    private Integer limit;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public void setDocumentIds(List<String> documentIds) {
        this.documentIds = documentIds;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public AnnOption(Builder builder) {
        this.fieldName = builder.fieldName;
        this.data = builder.data;
        this.params = builder.params;
        this.documentIds = builder.documentIds;
        this.limit = builder.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String fieldName;
        private List<Object> data;
        private Params params;
        private List<String> documentIds;
        private Integer limit;

        private Builder() {
        }

        public Builder withFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder withData(List<Double> vector) {
            this.data = Arrays.asList(vector);
            return this;
        }

        public Builder withTextData(String texts) {
            this.data = Collections.singletonList(texts);
            return this;
        }

        public Builder withTextData(List<String> texts) {
            this.data = Collections.singletonList(texts);
            return this;
        }

        public Builder withParam(Params params) {
            this.params = params;
            return this;
        }

        public Builder withDocumentIds(List<String> documentIds) {
            this.documentIds = documentIds;
            return this;
        }

        public Builder withLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AnnOption build() {
            return new AnnOption(this);
        }
    }
}

