/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Filter {
    private String cond;

    public Filter(String cond) {
        this.cond = cond;
    }

    public Filter and(String cond) {
        this.cond = String.format("( %s ) and ( %s )", this.cond, cond);
        return this;
    }

    public Filter or(String cond) {
        this.cond = String.format("( %s ) or ( %s )", this.cond, cond);
        return this;
    }

    public Filter andNot(String cond) {
        this.cond = String.format("( %s ) and not ( %s )", this.cond, cond);
        return this;
    }

    public Filter orNot(String cond) {
        this.cond = String.format("( %s ) or not ( %s )", this.cond, cond);
        return this;
    }

    public static <T> String in(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s in (%s)", key, String.join((CharSequence)",", strValues));
    }

    public static <T> String notIn(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s not in (%s)", key, String.join((CharSequence)",", strValues));
    }

    public static <T> String include(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s include (%s)", key, String.join((CharSequence)",", strValues));
    }

    public static <T> String exclude(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s exclude (%s)", key, String.join((CharSequence)",", strValues));
    }

    public static <T> String includeAll(String key, List<T> values) {
        if (values == null || values.isEmpty()) {
            throw new ParamException("Filter in condition values is empty");
        }
        List strValues = values.get(0) instanceof String ? values.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()) : values.stream().map(x -> x + "").collect(Collectors.toList());
        return String.format("%s include all (%s)", key, String.join((CharSequence)",", strValues));
    }

    public String getCond() {
        return this.cond;
    }
}

