/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InsertParam {
    private boolean buildIndex;
    private List<Object> documents;

    private InsertParam(Builder builder) {
        this.documents = builder.documents;
        this.buildIndex = builder.buildIndex;
    }

    public boolean isBuildIndex() {
        return this.buildIndex;
    }

    public List<Object> getDocuments() {
        return this.documents;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean buildIndex = true;
        private List<Object> documents = new ArrayList<Object>();

        public Builder withBuildIndex(boolean buildIndex) {
            this.buildIndex = buildIndex;
            return this;
        }

        public Builder withDocuments(List<?> documents) {
            this.documents = Collections.unmodifiableList(documents);
            return this;
        }

        public Builder addDocument(Object document) {
            this.documents.add(document);
            return this;
        }

        public Builder addAllDocument(List<?> documentList) {
            this.documents.addAll(documentList);
            return this;
        }

        public InsertParam build() {
            if (this.documents.isEmpty()) {
                throw new ParamException("InsertParam error: documents is empty");
            }
            return new InsertParam(this);
        }
    }
}

