/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MatchOption {
    private String fieldName;
    private List<List<List<Object>>> data;
    private Integer limit;
    private Integer terminateAfter;
    private Double cutoffFrequency;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<List<List<Object>>> getData() {
        return this.data;
    }

    public void setData(List<List<List<Object>>> data) {
        this.data = data;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getTerminateAfter() {
        return this.terminateAfter;
    }

    public void setTerminateAfter(Integer terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public Double getCutoffFrequency() {
        return this.cutoffFrequency;
    }

    public void setCutoffFrequency(double cutoffFrequency) {
        this.cutoffFrequency = cutoffFrequency;
    }

    public MatchOption(Builder builder) {
        this.fieldName = builder.fieldName;
        this.data = builder.data;
        this.limit = builder.limit;
        this.terminateAfter = builder.terminateAfter;
        this.cutoffFrequency = builder.cutoffFrequency;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String fieldName;
        private List<List<List<Object>>> data;
        private Integer limit;
        private Integer terminateAfter;
        private double cutoffFrequency;

        private Builder() {
        }

        public Builder withFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder withData(List<List<Pair<Long, Float>>> data) {
            ArrayList<List<List<Object>>> sparseData = new ArrayList<List<List<Object>>>();
            for (List<Pair<Long, Float>> dataItem : data) {
                ArrayList pairsList = new ArrayList();
                for (Pair<Long, Float> dataItemItem : dataItem) {
                    ArrayList<Object> pairTmp = new ArrayList<Object>();
                    pairTmp.add(dataItemItem.getLeft());
                    pairTmp.add(dataItemItem.getRight());
                    pairsList.add(pairTmp);
                }
                sparseData.add(pairsList);
            }
            this.data = sparseData;
            return this;
        }

        public Builder withLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder withTerminateAfter(Integer terminateAfter) {
            this.terminateAfter = terminateAfter;
            return this;
        }

        public Builder withCutoffFrequency(double cutoffFrequency) {
            this.cutoffFrequency = cutoffFrequency;
            return this;
        }

        public MatchOption build() {
            if (this.fieldName == null || this.data.isEmpty()) {
                throw new ParamException("RetrieveOption error: fieldName or data is null");
            }
            return new MatchOption(this);
        }
    }
}

