/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.param.enums.OrderEnum;

public class OrderRule {
    private String fieldName;
    private String direction;

    private OrderRule(Builder builder) {
        this.fieldName = builder.fieldName;
        this.direction = builder.direction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDirection() {
        return this.direction;
    }

    public static class Builder {
        private String fieldName;
        private String direction = "asc";

        public Builder withFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder withDirection(String direction) {
            this.direction = direction;
            return this;
        }

        public Builder withDirection(OrderEnum direction) {
            this.direction = direction.getOrder();
            return this;
        }

        public OrderRule build() {
            if (this.fieldName == null) {
                throw new ParamException("fieldName can not be null");
            }
            return new OrderRule(this);
        }
    }
}

