/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.model.param.dml.BaseQuery;
import com.tencent.tcvectordb.model.param.dml.OrderRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueryParam
extends BaseQuery {
    private boolean retrieveVector;
    private long limit;
    private long offset;
    private List<String> outputFields;
    private List<OrderRule> sort;

    public List<OrderRule> getSort() {
        return this.sort;
    }

    public void setSort(List<OrderRule> sort) {
        this.sort = sort;
    }

    public boolean isRetrieveVector() {
        return this.retrieveVector;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public QueryParam(Builder builder) {
        super(builder);
        this.retrieveVector = builder.retrieveVector;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.sort = builder.sort;
        if (builder.outputFields != null && !builder.outputFields.isEmpty()) {
            this.outputFields = Collections.unmodifiableList(builder.outputFields);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends BaseQuery.Builder<Builder> {
        private boolean retrieveVector = false;
        private long limit = 10L;
        private long offset = 0L;
        private List<String> outputFields = new ArrayList<String>();
        private List<OrderRule> sort;

        private Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder withRetrieveVector(boolean retrieveVector) {
            this.retrieveVector = retrieveVector;
            return this;
        }

        public Builder withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder withOffset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder addOutputFields(String outputField) {
            this.outputFields.add(outputField);
            return this;
        }

        public Builder addAllOutputFields(List<String> outputFields) {
            this.outputFields.addAll(outputFields);
            return this;
        }

        public Builder addAllOutputFields(String ... outputFields) {
            if (outputFields == null || outputFields.length == 0) {
                return this.self();
            }
            this.outputFields.addAll(Arrays.asList(outputFields));
            return this.self();
        }

        public Builder withOutputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        public Builder withSort(OrderRule sort) {
            this.sort = Collections.singletonList(sort);
            return this;
        }

        public QueryParam build() {
            return new QueryParam(this);
        }
    }
}

