/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.param.dml.SearchParam;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchByIdParam
extends SearchParam {
    private List<String> documentIds;

    private SearchByIdParam(Builder builder) {
        super(builder);
        this.documentIds = builder.documentIds;
    }

    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends SearchParam.Builder<Builder> {
        private List<String> documentIds = new ArrayList<String>();

        private Builder() {
        }

        public Builder withDocumentIds(List<String> documentIds) {
            this.documentIds = documentIds;
            return this;
        }

        public Builder addDocumentId(String documentId) {
            this.documentIds.add(documentId);
            return this;
        }

        public SearchByIdParam build() {
            if (this.documentIds == null || this.documentIds.isEmpty()) {
                throw new ParamException("SearchByVectorsBuilder error: documentIds is empty");
            }
            return new SearchByIdParam(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

