/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.exception.ParamException;
import com.tencent.tcvectordb.model.param.dml.SearchParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchByVectorParam
extends SearchParam {
    private List<List<? extends Number>> vectors;

    private SearchByVectorParam(Builder builder) {
        super(builder);
        this.vectors = builder.vectors;
    }

    public List<List<? extends Number>> getVectors() {
        return this.vectors;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends SearchParam.Builder<Builder> {
        private List<List<? extends Number>> vectors = new ArrayList<List<? extends Number>>();

        private Builder() {
        }

        public Builder withVectors(List<? extends List<? extends Number>> vectors) {
            this.vectors = vectors.stream().collect(Collectors.toList());
            return this;
        }

        public Builder addVector(List<? extends Number> vector) {
            this.vectors.add(vector);
            return this;
        }

        public SearchByVectorParam build() {
            if (this.vectors == null || this.vectors.isEmpty()) {
                throw new ParamException("SearchByVectorsBuilder error: vectors is empty");
            }
            return new SearchByVectorParam(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

