/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.dml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.model.param.dml.Filter;
import com.tencent.tcvectordb.model.param.dml.Params;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class SearchParam {
    protected Params params;
    protected String filter;
    protected List<String> outputFields;
    protected boolean retrieveVector;
    protected int limit;
    protected Float radius;

    protected SearchParam(Builder<?> builder) {
        this.params = builder.params;
        if (builder.filter != null) {
            this.filter = builder.filter;
        }
        if (builder.outputFields != null && !builder.outputFields.isEmpty()) {
            this.outputFields = Collections.unmodifiableList(builder.outputFields);
        }
        this.retrieveVector = builder.retrieveVector;
        this.limit = builder.limit;
        this.radius = builder.radius;
    }

    public Params getParams() {
        return this.params;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public boolean isRetrieveVector() {
        return this.retrieveVector;
    }

    public int getLimit() {
        return this.limit;
    }

    public Float getRadius() {
        return this.radius;
    }

    protected static abstract class Builder<T extends Builder<T>> {
        protected Params params;
        protected String filter;
        protected List<String> outputFields;
        protected boolean retrieveVector = false;
        protected int limit = 10;
        protected Float radius;

        protected Builder() {
        }

        protected abstract T self();

        public T withParams(Params params) {
            this.params = params;
            return this.self();
        }

        public T withOutputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this.self();
        }

        public T withFilter(Filter filter) {
            if (filter != null) {
                this.filter = filter.getCond();
            }
            return this.self();
        }

        public T withFilter(String filter) {
            this.filter = filter;
            return this.self();
        }

        public T withRetrieveVector(boolean retrieveVector) {
            this.retrieveVector = retrieveVector;
            return this.self();
        }

        public T withLimit(int limit) {
            this.limit = limit;
            return this.self();
        }

        public T withRadius(Float radius) {
            this.radius = radius;
            return this.self();
        }

        public T withRadius(Number radius) {
            this.radius = Float.valueOf(radius.floatValue());
            return this.self();
        }
    }
}

