/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.entity;

import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.Document;
import com.tencent.tcvectordb.model.param.entity.BaseRes;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class HybridSearchRes
extends BaseRes {
    private List<Object> documents;

    public List<Document> getDocuments() throws VectorDBException {
        if (this.documents.size() == 0) {
            return Collections.emptyList();
        }
        if (this.documents.get(0) instanceof Document) {
            return this.documents.stream().map(o -> (Document)o).collect(Collectors.toList());
        }
        throw new VectorDBException("hybrid search response data type is List<List<Document>>, please use method: getDocumentsList");
    }

    public List<List<Document>> getDocumentsList() throws VectorDBException {
        if (this.documents.size() == 0) {
            return Collections.emptyList();
        }
        if (this.documents.get(0) instanceof List) {
            return this.documents.stream().map(array -> (List)array).collect(Collectors.toList());
        }
        throw new VectorDBException("hybrid search response data type is List<Document>, please use method: getDocuments");
    }

    public HybridSearchRes(int code, String msg, String warning, List<Object> documents) {
        super(code, msg, warning);
        this.documents = documents;
    }

    @Override
    public String toString() {
        return "HybridSearchRes{documents=" + this.documents + ", code=" + this.code + ", msg='" + this.msg + '\'' + ", warning='" + this.warning + '\'' + '}';
    }
}

