/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tencent.tcvectordb.model.DocField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchDocumentSetInfo {
    private String documentSetName;
    private String documentSetId;
    private List<DocField> docFields;
    private Map<String, Object> docKeyValue;

    public SearchDocumentSetInfo(Builder builder) {
        this.documentSetId = builder.documentSetId;
        this.documentSetName = builder.documentSetName;
        this.docFields = builder.docFields;
    }

    @JsonIgnore
    public Map<String, Object> getDocKeyValue() {
        if (Objects.isNull(this.docFields) || this.docFields.isEmpty()) {
            return null;
        }
        this.ensureDocKeyValue();
        return this.docKeyValue;
    }

    @JsonIgnore
    public Object getObject(String key) {
        if (Objects.isNull(this.docFields) || this.docFields.isEmpty()) {
            return null;
        }
        this.ensureDocKeyValue();
        return this.docKeyValue.get(key);
    }

    private void ensureDocKeyValue() {
        if (Objects.isNull(this.docKeyValue)) {
            this.docKeyValue = new TreeMap<String, Object>();
            for (DocField docField : this.docFields) {
                this.docKeyValue.put(docField.getName(), docField.getValue());
            }
        }
    }

    public String getDocumentSetName() {
        return this.documentSetName;
    }

    public void setDocumentSetName(String documentSetName) {
        this.documentSetName = documentSetName;
    }

    public String getDocumentSetId() {
        return this.documentSetId;
    }

    public void setDocumentSetId(String documentSetId) {
        this.documentSetId = documentSetId;
    }

    public List<DocField> getDocFields() {
        return this.docFields;
    }

    public void setDocFields(List<DocField> docFields) {
        this.docFields = docFields;
    }

    public String toString() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (this.documentSetName != null) {
            node.put("documentSetName", this.documentSetName);
        }
        if (this.documentSetId != null) {
            node.put("documentSetId", this.documentSetId);
        }
        if (this.docFields != null && !this.docFields.isEmpty()) {
            block4: for (DocField field : this.docFields) {
                switch (field.getFieldType()) {
                    case Uint64: {
                        node.put(field.getName(), Long.valueOf(field.getStringValue()));
                        continue block4;
                    }
                    case Array: {
                        List strValues = (List)field.getValue();
                        ArrayNode strNode = JsonNodeFactory.instance.arrayNode();
                        strValues.forEach(arg_0 -> ((ArrayNode)strNode).add(arg_0));
                        node.set(field.getName(), (JsonNode)strNode);
                        continue block4;
                    }
                }
                node.put(field.getName(), field.getStringValue());
            }
        }
        return node.toString();
    }

    public void addFilterField(DocField docField) {
        if (this.getDocFields() == null) {
            this.docFields = new ArrayList<DocField>();
        }
        this.docFields.add(docField);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String documentSetName;
        private String documentSetId;
        private List<DocField> docFields = new ArrayList<DocField>();

        public Builder withDocumentSetName(String documentSetName) {
            this.documentSetName = documentSetName;
            return this;
        }

        public Builder withDocumentSetId(String documentSetId) {
            this.documentSetId = documentSetId;
            return this;
        }

        public Builder addDocField(DocField docField) {
            this.docFields.add(docField);
            return this;
        }

        public SearchDocumentSetInfo build() {
            return new SearchDocumentSetInfo(this);
        }
    }
}

