/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.model.param.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tencent.tcvectordb.model.param.user.PrivilegeParam;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserRevokeParam {
    private String user;
    private List<PrivilegeParam> privileges;

    private UserRevokeParam(Builder builder) {
        this.user = builder.user;
        this.privileges = builder.privileges;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUser() {
        return this.user;
    }

    public List<PrivilegeParam> getPrivileges() {
        return this.privileges;
    }

    public String toString() {
        return JsonUtils.toJsonString(this);
    }

    public static class Builder {
        private String user;
        private List<PrivilegeParam> privileges = new ArrayList<PrivilegeParam>();

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withPrivileges(List<PrivilegeParam> privileges) {
            this.privileges.addAll(privileges);
            return this;
        }

        public Builder withPrivilege(PrivilegeParam privilege) {
            this.privileges.add(privilege);
            return this;
        }

        public UserRevokeParam build() {
            return new UserRevokeParam(this);
        }
    }
}

