/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.rpc.Interceptor;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendServiceInterceptor
implements ClientInterceptor {
    private final Metadata.Key<String> backendKey = Metadata.Key.of((String)"backend-service", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private String backendValue;
    private static final Logger logger = LoggerFactory.getLogger((String)BackendServiceInterceptor.class.getName());

    public BackendServiceInterceptor(Boolean ai) {
        this.backendValue = ai != false ? "ai" : "vdb";
        logger.debug("Backend: {}", (Object)this.backendValue);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Object call = next.newCall(method, callOptions);
        call = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>((ClientCall)call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(BackendServiceInterceptor.this.backendKey, (Object)BackendServiceInterceptor.this.backendValue);
                super.start(responseListener, headers);
            }
        };
        return call;
    }
}

