/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.rpc.pool;

import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.param.database.ConnectParam;
import com.tencent.tcvectordb.rpc.Interceptor.AuthorityInterceptor;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.okhttp.OkHttpChannelBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ChannelPool {
    private final GenericObjectPool<ManagedChannel> pool;

    public ChannelPool(ConnectParam param, int maxReceiveMessageSize, String authorization) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(param.getMaxIdleConnections());
        config.setMaxIdle(param.getMaxIdleConnections());
        config.setMaxWait(Duration.ofSeconds(param.getConnectTimeout()));
        this.pool = new GenericObjectPool((PooledObjectFactory)new ChannelFactory(this.getAddress(param.getUrl()), maxReceiveMessageSize, authorization), config);
        for (int i = 0; i < this.pool.getMaxIdle(); ++i) {
            try {
                this.pool.addObject();
                continue;
            }
            catch (Exception e) {
                throw new VectorDBException("create channel pool error", e);
            }
        }
    }

    private String getAddress(String url) {
        URL _url = null;
        try {
            _url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (_url.getPort() <= 0) {
            url = url + ":80";
        }
        return url.replaceFirst("http://", "").replaceFirst("https://", "");
    }

    public ManagedChannel getChannel() {
        try {
            return (ManagedChannel)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void returnChannel(ManagedChannel channel) {
        this.pool.returnObject((Object)channel);
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public void printPoolStats() {
        System.out.println("Active: " + this.pool.getNumActive());
        System.out.println("Idle: " + this.pool.getNumIdle());
        System.out.println("Total created: " + this.pool.getCreatedCount());
        System.out.println("Total borrowed: " + this.pool.getBorrowedCount());
        System.out.println("Total returned: " + this.pool.getReturnedCount());
    }

    private static class ChannelFactory
    extends BasePooledObjectFactory<ManagedChannel> {
        private final String url;
        private final int maxReceiveMessageSize;
        private final String authorization;

        public ChannelFactory(String url, int maxReceiveMessageSize, String authorization) {
            this.url = url;
            this.maxReceiveMessageSize = maxReceiveMessageSize;
            this.authorization = authorization;
        }

        public ManagedChannel create() {
            return ((OkHttpChannelBuilder)((OkHttpChannelBuilder)OkHttpChannelBuilder.forTarget((String)this.url).intercept(new ClientInterceptor[]{new AuthorityInterceptor(this.authorization)})).flowControlWindow(this.maxReceiveMessageSize).maxInboundMessageSize(this.maxReceiveMessageSize).enableRetry()).usePlaintext().build();
        }

        public PooledObject<ManagedChannel> wrap(ManagedChannel channel) {
            return new DefaultPooledObject((Object)channel);
        }

        public void destroyObject(PooledObject<ManagedChannel> p) {
            ((ManagedChannel)p.getObject()).shutdown();
        }
    }
}

