/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.serializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.tencent.tcvectordb.model.param.collection.Embedding;
import com.tencent.tcvectordb.model.param.enums.EmbeddingModelEnum;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class EmbeddingDeserialize
extends JsonDeserializer<Embedding> {
    public Embedding deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        String paramsStr = p.getCodec().readTree(p).toString();
        if (StringUtils.isBlank((CharSequence)paramsStr)) {
            return null;
        }
        JsonNode jsonNode = JsonUtils.parseToJsonNode(paramsStr);
        Embedding.Builder builder = Embedding.newBuilder();
        if (jsonNode.has("field")) {
            builder.withField(jsonNode.get("field").asText());
        }
        if (jsonNode.has("vectorField")) {
            builder.withVectorField(jsonNode.get("vectorField").asText());
        }
        if (jsonNode.has("model")) {
            String modelName = jsonNode.get("model").asText();
            builder.withModelName(modelName);
            EmbeddingModelEnum embeddingModelEnum = EmbeddingModelEnum.find(modelName);
            if (embeddingModelEnum != null) {
                builder.withModel(embeddingModelEnum);
            }
        }
        if (jsonNode.has("status")) {
            builder.withStatus(jsonNode.get("status").asText());
        }
        return builder.build();
    }
}

