/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tcvectordb.serializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.tencent.tcvectordb.exception.VectorDBException;
import com.tencent.tcvectordb.model.param.collection.HNSWParams;
import com.tencent.tcvectordb.model.param.collection.IVFFLATParams;
import com.tencent.tcvectordb.model.param.collection.IVFPQParams;
import com.tencent.tcvectordb.model.param.collection.IVFSQ8Params;
import com.tencent.tcvectordb.model.param.collection.IndexField;
import com.tencent.tcvectordb.model.param.collection.ParamsSerializer;
import com.tencent.tcvectordb.utils.JsonUtils;
import java.io.IOException;

public class ParamsDeserialize
extends JsonDeserializer<ParamsSerializer> {
    public ParamsSerializer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        IndexField indexField;
        String paramsStr = p.getCodec().readTree(p).toString();
        Object o = p.getCurrentValue();
        if (o instanceof IndexField && (indexField = (IndexField)o).isVectorField()) {
            ParamsSerializer params = null;
            switch (indexField.getIndexType()) {
                case HNSW: {
                    params = JsonUtils.parseObject(paramsStr, HNSWParams.class);
                    break;
                }
                case IVF_FLAT: {
                    params = JsonUtils.parseObject(paramsStr, IVFFLATParams.class);
                    break;
                }
                case IVF_PQ: {
                    params = JsonUtils.parseObject(paramsStr, IVFPQParams.class);
                    break;
                }
                case IVF_SQ8: {
                    params = JsonUtils.parseObject(paramsStr, IVFSQ8Params.class);
                }
            }
            return params;
        }
        throw new VectorDBException("deserialize IndexField exception, expect IndexField class, actually value is " + o.toString());
    }
}

